/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.config.spring.k8s;

import com.google.common.io.Resources;
import com.predic8.membrane.core.config.spring.k8s.Envelope;
import com.predic8.membrane.core.kubernetes.BeanRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;

public class YamlLoader {
    public Envelope loadResource(String resource, BeanRegistry registry) throws IOException {
        BufferedReader br = Resources.asCharSource((URL)Resources.getResource((String)resource), (Charset)StandardCharsets.UTF_8).openBufferedStream();
        return this.load(br, registry);
    }

    public Envelope load(Reader reader, BeanRegistry registry) throws IOException {
        Yaml yaml = new Yaml();
        Iterable iterable = yaml.parse(reader);
        Iterator<Event> i = iterable.iterator();
        Envelope e = new Envelope();
        e.parse(i, registry);
        return e;
    }

    public static String readString(Iterator<Event> events) {
        Event event = events.next();
        if (event instanceof ScalarEvent) {
            return ((ScalarEvent)event).getValue();
        }
        throw new IllegalStateException("Expected string in line " + event.getStartMark().getLine() + " column " + event.getStartMark().getColumn());
    }

    public static Object readObj(Iterator<Event> events) {
        Event event = events.next();
        if (event instanceof ScalarEvent) {
            return ((ScalarEvent)event).getValue();
        }
        if (event instanceof MappingStartEvent) {
            return YamlLoader.readMap(events);
        }
        if (event instanceof SequenceStartEvent) {
            return YamlLoader.readSequence(events);
        }
        throw new IllegalStateException("Expected scalar, map or sequence in line " + event.getStartMark().getLine() + " column " + event.getStartMark().getColumn());
    }

    public static List readSequence(Iterator<Event> events) {
        Event event;
        ArrayList<Object> res = new ArrayList<Object>();
        while (true) {
            if ((event = events.next()) instanceof ScalarEvent) {
                String value = ((ScalarEvent)event).getValue();
                res.add(value);
                continue;
            }
            if (event instanceof MappingStartEvent) {
                res.add(YamlLoader.readMap(events));
                continue;
            }
            if (!(event instanceof SequenceStartEvent)) break;
            res.add(YamlLoader.readSequence(events));
        }
        if (!(event instanceof SequenceEndEvent)) {
            throw new IllegalStateException("Expected scalar or end-of-map in line " + event.getStartMark().getLine() + " column " + event.getStartMark().getColumn());
        }
        return res;
    }

    public static Map readMap(Iterator<Event> events) {
        Event event;
        HashMap<String, Object> res = new HashMap<String, Object>();
        while ((event = events.next()) instanceof ScalarEvent) {
            String key = ((ScalarEvent)event).getValue();
            Object value = YamlLoader.readObj(events);
            res.put(key, value);
        }
        if (!(event instanceof MappingEndEvent)) {
            throw new IllegalStateException("Expected scalar or end-of-map in line " + event.getStartMark().getLine() + " column " + event.getStartMark().getColumn());
        }
        return res;
    }
}

