/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exchange.snapshots;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.exchange.ExchangeState;
import com.predic8.membrane.core.exchange.snapshots.FakeRule;
import com.predic8.membrane.core.exchange.snapshots.RequestSnapshot;
import com.predic8.membrane.core.exchange.snapshots.ResponseSnapshot;
import com.predic8.membrane.core.http.BodyCollectingMessageObserver;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.util.functionalInterfaces.Consumer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AbstractExchangeSnapshot {
    @JsonIgnore
    private final Consumer<AbstractExchangeSnapshot> bodyCopiedCallback;
    @JsonIgnore
    private final BodyCollectingMessageObserver.Strategy strategy;
    @JsonIgnore
    private final long limit;
    RequestSnapshot request;
    ResponseSnapshot response;
    String originalRequestUri;
    Calendar time;
    String errorMessage;
    ExchangeState status;
    long timeReqSent;
    long timeReqReceived;
    long timeResSent;
    long timeResReceived;
    List<String> destinations;
    String remoteAddr;
    String remoteAddrIp;
    FakeRule rule;
    String server;
    long id;

    public AbstractExchangeSnapshot(AbstractExchange exc, Interceptor.Flow flow, Consumer<AbstractExchangeSnapshot> bodyCopiedCallback, BodyCollectingMessageObserver.Strategy strategy, long limit) throws IOException {
        this.bodyCopiedCallback = bodyCopiedCallback;
        this.strategy = strategy;
        this.limit = limit;
        this.updateFrom(exc, flow);
    }

    public AbstractExchangeSnapshot() {
        this.bodyCopiedCallback = null;
        this.strategy = BodyCollectingMessageObserver.Strategy.ERROR;
        this.limit = -1L;
    }

    public <T extends AbstractExchangeSnapshot> T updateFrom(AbstractExchange source, Interceptor.Flow flow) throws IOException {
        switch (flow) {
            case REQUEST: {
                if (source.getRequest() == null) break;
                this.setRequest(new RequestSnapshot(source.getRequest(), this.bodyCopiedCallback, this, this.strategy, this.limit));
                break;
            }
            case RESPONSE: 
            case ABORT: {
                if (source.getResponse() == null) break;
                this.setResponse(new ResponseSnapshot(source.getResponse(), this.bodyCopiedCallback, this, this.strategy, this.limit));
            }
        }
        this.setOriginalRequestUri(source.getOriginalRequestUri());
        this.setTime(source.getTime());
        this.setErrorMessage(source.getErrorMessage());
        this.setStatus(source.getStatus());
        this.setTimeReqSent(source.getTimeReqSent());
        this.setTimeReqReceived(source.getTimeReqReceived());
        this.setTimeResSent(source.getTimeResSent());
        this.setTimeResReceived(source.getTimeResReceived());
        this.setDestinations(new ArrayList<String>(source.getDestinations()));
        this.setRemoteAddr(source.getRemoteAddr());
        this.setRemoteAddrIp(source.getRemoteAddrIp());
        this.setId(source.getId());
        this.setRule(new FakeRule(source.getRule()));
        this.setServer(source.getServer());
        return (T)this;
    }

    public AbstractExchange toAbstractExchange() {
        Exchange exc = new Exchange(null);
        if (this.getRequest() != null) {
            exc.setRequest(this.getRequest().toRequest());
        }
        if (this.getResponse() != null) {
            exc.setResponse(this.getResponse().toResponse());
        }
        exc.setOriginalRequestUri(this.getOriginalRequestUri());
        exc.setTime(this.getTime());
        exc.setErrorMessage(this.getErrorMessage());
        exc.setStatus(this.getStatus());
        exc.setTimeReqSent(this.getTimeReqSent());
        exc.setTimeReqReceived(this.getTimeReqReceived());
        exc.setTimeResSent(this.getTimeResSent());
        exc.setTimeResReceived(this.getTimeResReceived());
        exc.setDestinations(new ArrayList<String>(this.getDestinations()));
        exc.setRemoteAddr(this.getRemoteAddr());
        exc.setRemoteAddrIp(this.getRemoteAddrIp());
        exc.setId(this.getId());
        exc.setRule(this.getRule());
        this.setServer(this.getServer());
        return exc;
    }

    public RequestSnapshot getRequest() {
        return this.request;
    }

    public void setRequest(RequestSnapshot request) {
        this.request = request;
    }

    public ResponseSnapshot getResponse() {
        return this.response;
    }

    public void setResponse(ResponseSnapshot response) {
        this.response = response;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getOriginalRequestUri() {
        return this.originalRequestUri;
    }

    public void setOriginalRequestUri(String originalRequestUri) {
        this.originalRequestUri = originalRequestUri;
    }

    public Calendar getTime() {
        return this.time;
    }

    public void setTime(Calendar time) {
        this.time = time;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public ExchangeState getStatus() {
        return this.status;
    }

    public void setStatus(ExchangeState status) {
        this.status = status;
    }

    public long getTimeReqSent() {
        return this.timeReqSent;
    }

    public void setTimeReqSent(long timeReqSent) {
        this.timeReqSent = timeReqSent;
    }

    public long getTimeReqReceived() {
        return this.timeReqReceived;
    }

    public void setTimeReqReceived(long timeReqReceived) {
        this.timeReqReceived = timeReqReceived;
    }

    public long getTimeResSent() {
        return this.timeResSent;
    }

    public void setTimeResSent(long timeResSent) {
        this.timeResSent = timeResSent;
    }

    public long getTimeResReceived() {
        return this.timeResReceived;
    }

    public void setTimeResReceived(long timeResReceived) {
        this.timeResReceived = timeResReceived;
    }

    public List<String> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(List<String> destinations) {
        this.destinations = destinations;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteAddrIp() {
        return this.remoteAddrIp;
    }

    public void setRemoteAddrIp(String remoteAddrIp) {
        this.remoteAddrIp = remoteAddrIp;
    }

    public FakeRule getRule() {
        return this.rule;
    }

    public void setRule(FakeRule rule) {
        this.rule = rule;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }
}

