/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exchange.snapshots;

import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchange.snapshots.AbstractExchangeSnapshot;
import com.predic8.membrane.core.http.AbstractBody;
import com.predic8.membrane.core.http.BodyCollectingMessageObserver;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.model.AbstractExchangeViewerListener;
import com.predic8.membrane.core.util.functionalInterfaces.Consumer;
import groovy.lang.Tuple2;
import java.io.IOException;
import java.util.stream.Stream;

public class DynamicAbstractExchangeSnapshot
extends AbstractExchangeSnapshot {
    public DynamicAbstractExchangeSnapshot(AbstractExchange exc, Interceptor.Flow flow, Consumer<AbstractExchangeSnapshot> bodyCopiedCallback, BodyCollectingMessageObserver.Strategy strategy, long limit) throws IOException {
        super(exc, flow, bodyCopiedCallback, strategy, limit);
        DynamicAbstractExchangeSnapshot.addObservers(exc, this, bodyCopiedCallback, flow);
    }

    public DynamicAbstractExchangeSnapshot() {
    }

    public static void addObservers(final AbstractExchange exc, final AbstractExchangeSnapshot excCopy, final Consumer<AbstractExchangeSnapshot> callback, final Interceptor.Flow flow) {
        exc.addExchangeViewerListener(new AbstractExchangeViewerListener(){

            @Override
            public void addResponse(Response response) {
                response.addObserver(new UpdateExchangeCopyObserver(callback, excCopy, exc, Interceptor.Flow.RESPONSE));
            }

            @Override
            public void setExchangeFinished() {
                DynamicAbstractExchangeSnapshot.update(callback, excCopy, exc, flow);
            }
        });
        Stream.of(new Tuple2((Object)Interceptor.Flow.REQUEST, (Object)exc.getRequest()), new Tuple2((Object)Interceptor.Flow.RESPONSE, (Object)exc.getResponse())).forEach(t -> {
            Interceptor.Flow flow2 = (Interceptor.Flow)((Object)((Object)t.getFirst()));
            Message msg = (Message)t.getSecond();
            if (msg == null) {
                return;
            }
            if (!msg.getBody().getObservers().stream().anyMatch(obs -> obs instanceof UpdateExchangeCopyObserver)) {
                msg.addObserver(new UpdateExchangeCopyObserver(callback, excCopy, exc, flow2));
            }
        });
        DynamicAbstractExchangeSnapshot.update(callback, excCopy, exc, flow);
    }

    public static void update(Consumer<AbstractExchangeSnapshot> callback, AbstractExchangeSnapshot excCopy, AbstractExchange exc, Interceptor.Flow flow) {
        try {
            excCopy = excCopy.updateFrom(exc, flow);
            if (callback != null) {
                callback.call(excCopy);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class UpdateExchangeCopyObserver
    extends BodyCollectingMessageObserver {
        private final Consumer<AbstractExchangeSnapshot> callback;
        private final AbstractExchangeSnapshot excCopy;
        private final AbstractExchange exc;
        private final Interceptor.Flow flow;

        public UpdateExchangeCopyObserver(Consumer<AbstractExchangeSnapshot> callback, AbstractExchangeSnapshot excCopy, AbstractExchange exc, Interceptor.Flow flow) {
            super(BodyCollectingMessageObserver.Strategy.TRUNCATE, -1L);
            this.callback = callback;
            this.excCopy = excCopy;
            this.exc = exc;
            this.flow = flow;
        }

        @Override
        public void bodyRequested(AbstractBody body) {
        }

        @Override
        public void bodyComplete(AbstractBody body) {
            DynamicAbstractExchangeSnapshot.update(this.callback, this.excCopy, this.exc, this.flow);
        }
    }
}

