/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exchange.snapshots;

import com.predic8.membrane.core.exchange.snapshots.AbstractExchangeSnapshot;
import com.predic8.membrane.core.http.AbstractBody;
import com.predic8.membrane.core.http.Body;
import com.predic8.membrane.core.http.BodyCollectingMessageObserver;
import com.predic8.membrane.core.http.EmptyBody;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.util.functionalInterfaces.Consumer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;

public class MessageSnapshot {
    Map<String, String> header;
    byte[] body = null;

    public MessageSnapshot(Message msg, Consumer<AbstractExchangeSnapshot> bodyCopiedCallback, AbstractExchangeSnapshot aes, final BodyCollectingMessageObserver.Strategy strategy, final long limit) throws IOException {
        this.header = new HashMap<String, String>();
        Stream.of(msg.getHeader().getAllHeaderFields()).forEach(headerField -> {
            String key = headerField.getHeaderName().toString();
            String value = this.header.get(key);
            if (value != null) {
                this.header.put(key, value + ", " + headerField.getValue());
            } else {
                this.header.put(key, headerField.getValue());
            }
        });
        if (bodyCopiedCallback == null) {
            this.body = IOUtils.toByteArray((InputStream)new CountingInputStream(msg.getBodyAsStreamDecoded()){

                public int read(byte[] b) throws IOException {
                    if (limit != -1L && (long)this.getCount() > limit) {
                        switch (strategy) {
                            case TRUNCATE: {
                                return -1;
                            }
                            case ERROR: {
                                throw new IOException("Body too large. (limit = " + limit + ")");
                            }
                        }
                    }
                    return super.read(b);
                }
            });
        } else {
            msg.addObserver(new SnapshottingObserver(strategy, limit, bodyCopiedCallback, aes));
        }
    }

    public MessageSnapshot() {
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    public void setHeader(Map<String, String> header) {
        this.header = header;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public Header convertHeader() {
        Header result = new Header();
        this.header.keySet().stream().forEach(key -> result.add((String)key, this.header.get(key)));
        return result;
    }

    public AbstractBody convertBody() {
        if (this.body == null) {
            return new EmptyBody();
        }
        return new Body(this.body);
    }

    private class SnapshottingObserver
    extends BodyCollectingMessageObserver {
        private final Consumer<AbstractExchangeSnapshot> bodyCopiedCallback;
        private final AbstractExchangeSnapshot aes;

        public SnapshottingObserver(BodyCollectingMessageObserver.Strategy strategy, long limit, Consumer<AbstractExchangeSnapshot> bodyCopiedCallback, AbstractExchangeSnapshot aes) {
            super(strategy, limit);
            this.bodyCopiedCallback = bodyCopiedCallback;
            this.aes = aes;
        }

        @Override
        public void bodyRequested(AbstractBody body) {
        }

        @Override
        public void bodyComplete(AbstractBody body2) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                InputStream body1 = this.getBody(body2).getContentAsStream();
                IOUtils.copy((InputStream)body1, (OutputStream)baos);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            MessageSnapshot.this.body = baos.toByteArray();
            try {
                this.bodyCopiedCallback.call(this.aes);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

