/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exchangestore;

import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchangestore.ClientStatistics;
import com.predic8.membrane.core.exchangestore.ExchangeCollector;
import com.predic8.membrane.core.exchangestore.ExchangeQueryResult;
import com.predic8.membrane.core.exchangestore.ExchangeStore;
import com.predic8.membrane.core.interceptor.administration.AdminRESTInterceptor;
import com.predic8.membrane.core.interceptor.rest.QueryParameter;
import com.predic8.membrane.core.model.IExchangesStoreListener;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.util.ComparatorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExchangeStore
implements ExchangeStore {
    private static final Logger log = LoggerFactory.getLogger(AbstractExchangeStore.class);
    protected Set<IExchangesStoreListener> exchangesStoreListeners = new HashSet<IExchangesStoreListener>();

    @Override
    public void addExchangesStoreListener(IExchangesStoreListener viewer) {
        this.exchangesStoreListeners.add(viewer);
    }

    @Override
    public void removeExchangesStoreListener(IExchangesStoreListener viewer) {
        this.exchangesStoreListeners.remove(viewer);
    }

    @Override
    public void refreshExchangeStoreListeners() {
        for (IExchangesStoreListener listener : this.exchangesStoreListeners) {
            listener.refresh();
        }
    }

    @Override
    public void notifyListenersOnExchangeAdd(Rule rule, AbstractExchange exchange) {
        for (IExchangesStoreListener listener : this.exchangesStoreListeners) {
            exchange.addExchangeStoreListener(listener);
            listener.addExchange(rule, exchange);
        }
    }

    @Override
    public void notifyListenersOnExchangeRemoval(AbstractExchange exchange) {
        for (IExchangesStoreListener listener : this.exchangesStoreListeners) {
            exchange.removeExchangeStoreListener(listener);
            listener.removeExchange(exchange);
        }
    }

    @Override
    public AbstractExchange getExchangeById(long id) {
        throw new UnsupportedOperationException("getExchangeById must be implemented in the sub class.");
    }

    @Override
    public List<? extends ClientStatistics> getClientStatistics() {
        throw new UnsupportedOperationException("getClientStatistics must be implemented in the sub class.");
    }

    @Override
    public void init(Router router) {
    }

    @Override
    public synchronized void collect(ExchangeCollector collector) {
        for (AbstractExchange exc : this.getAllExchangesAsList()) {
            try {
                collector.collect(exc);
            }
            catch (Exception e) {
                log.debug("Error while collecting properties from Exchange.", (Throwable)e);
            }
        }
    }

    @Override
    public long getLastModified() {
        return System.currentTimeMillis();
    }

    @Override
    public void waitForModification(long lastKnownModification) throws InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExchangeQueryResult getFilteredSortedPaged(QueryParameter params, boolean useXForwardedForAsClientAddr) throws Exception {
        List<AbstractExchange> exchanges;
        long lm;
        List<AbstractExchange> list = this.getAllExchangesAsList();
        synchronized (list) {
            lm = this.getLastModified();
            exchanges = new ArrayList<AbstractExchange>(this.getAllExchangesAsList());
        }
        exchanges = this.filter(params, useXForwardedForAsClientAddr, exchanges);
        Collections.sort(exchanges, ComparatorFactory.getAbstractExchangeComparator(params.getString("sort", "time"), params.getString("order", "desc")));
        int offset = params.getInt("offset", 0);
        int max = params.getInt("max", exchanges.size());
        int total = exchanges.size();
        List<AbstractExchange> paginated = exchanges.subList(offset, Math.min(offset + max, exchanges.size()));
        return new ExchangeQueryResult(paginated, total, lm);
    }

    private List<AbstractExchange> filter(QueryParameter params, boolean useXForwardedForAsClientAddr, List<AbstractExchange> exchanges) throws Exception {
        ArrayList<AbstractExchange> list = new ArrayList<AbstractExchange>();
        for (AbstractExchange e : exchanges) {
            if (params.has("proxy") && !e.getRule().toString().equals(params.getString("proxy")) || params.has("statuscode") && e.getResponse().getStatusCode() != params.getInt("statuscode") || params.has("client") && !AdminRESTInterceptor.getClientAddr(useXForwardedForAsClientAddr, e).equals(params.getString("client")) || params.has("server") && !params.getString("server").equals(e.getServer() == null ? "" : e.getServer()) || params.has("method") && !e.getRequest().getMethod().equals(params.getString("method")) || params.has("reqcontenttype") && !e.getRequestContentType().equals(params.getString("reqcontenttype")) || params.has("respcontenttype") && !e.getResponseContentType().equals(params.getString("respcontenttype"))) continue;
            list.add(e);
        }
        return list;
    }
}

