/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exchangestore;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.exchangestore.AbstractExchangeStore;
import com.predic8.membrane.core.exchangestore.ClientStatistics;
import com.predic8.membrane.core.exchangestore.ClientStatisticsCollector;
import com.predic8.membrane.core.http.BodyCollectingMessageObserver;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.model.AbstractExchangeViewerListener;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.rules.RuleKey;
import com.predic8.membrane.core.rules.StatisticCollector;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="limitedMemoryExchangeStore")
public class LimitedMemoryExchangeStore
extends AbstractExchangeStore {
    private static Logger log = LoggerFactory.getLogger(LimitedMemoryExchangeStore.class);
    private int maxSize = 1000000;
    private int maxBodySize = 100000;
    private int currentSize;
    private BodyCollectingMessageObserver.Strategy bodyExceedingMaxSizeStrategy = BodyCollectingMessageObserver.Strategy.TRUNCATE;
    private final Queue<AbstractExchange> exchanges = new LinkedList<AbstractExchange>();
    private final Queue<AbstractExchange> inflight = new LinkedList<AbstractExchange>();
    private long lastModification = System.currentTimeMillis();
    static final int additionalMemoryToAddInMb = 100;

    @Override
    public void snap(AbstractExchange exc, Interceptor.Flow flow) {
        this.newSnap(exc, flow);
    }

    private void newSnap(final AbstractExchange exc, Interceptor.Flow flow) {
        try {
            if (flow == Interceptor.Flow.REQUEST) {
                final AbstractExchange excCopy = this.snapInternal(exc, flow);
                if (exc.getRequest() != null) {
                    excCopy.setRequest((Request)exc.getRequest().createSnapshot(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            LimitedMemoryExchangeStore limitedMemoryExchangeStore = LimitedMemoryExchangeStore.this;
                            synchronized (limitedMemoryExchangeStore) {
                                LimitedMemoryExchangeStore.this.currentSize += -excCopy.resetHeapSizeEstimation() + excCopy.getHeapSizeEstimation();
                                LimitedMemoryExchangeStore.this.modify();
                            }
                        }
                    }, this.bodyExceedingMaxSizeStrategy, this.maxBodySize));
                }
                exc.addExchangeViewerListener(new AbstractExchangeViewerListener(){

                    @Override
                    public void setExchangeFinished() {
                        try {
                            LimitedMemoryExchangeStore.this.snapInternal(exc, Interceptor.Flow.RESPONSE);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                final AbstractExchange excCopy = this.snapInternal(exc, flow);
                if (exc.getResponse() != null) {
                    excCopy.setResponse((Response)exc.getResponse().createSnapshot(new Runnable(){

                        @Override
                        public void run() {
                            LimitedMemoryExchangeStore.this.currentSize += -excCopy.resetHeapSizeEstimation() + excCopy.getHeapSizeEstimation();
                            LimitedMemoryExchangeStore.this.modify();
                        }
                    }, this.bodyExceedingMaxSizeStrategy, this.maxBodySize));
                }
                this.modify();
            }
        }
        catch (Exception e) {
            log.warn("exception during snapshotting: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private synchronized AbstractExchange snapInternal(AbstractExchange orig, Interceptor.Flow flow) throws Exception {
        AbstractExchange exc = this.getExchangeById(orig.getId());
        if (exc == null) {
            final AbstractExchange exc2 = exc = orig.createSnapshot(null, null, 0L);
            exc.addExchangeViewerListener(new AbstractExchangeViewerListener(){

                @Override
                public void addRequest(Request request) {
                    LimitedMemoryExchangeStore.this.currentSize += -exc2.resetHeapSizeEstimation() + exc2.getHeapSizeEstimation();
                }

                @Override
                public void addResponse(Response response) {
                    LimitedMemoryExchangeStore.this.currentSize += -exc2.resetHeapSizeEstimation() + exc2.getHeapSizeEstimation();
                }
            });
        }
        this.makeSpaceIfNeeded(exc);
        if (flow == Interceptor.Flow.REQUEST) {
            if (this.inflight.add(exc)) {
                this.currentSize += exc.getHeapSizeEstimation();
            }
        } else {
            if (this.inflight.remove(exc)) {
                this.currentSize -= exc.getHeapSizeEstimation();
            }
            if (!this.exchanges.contains(exc)) {
                this.exchanges.add(exc);
                this.currentSize += exc.getHeapSizeEstimation();
            }
            Exchange.updateCopy(orig, exc, null, null, 0L);
        }
        this.modify();
        return exc;
    }

    @Override
    public synchronized void remove(AbstractExchange exc) {
        this.exchanges.remove(exc);
        this.modify();
    }

    @Override
    public synchronized void removeAllExchanges(Rule rule) {
        this.exchanges.removeAll(this.getExchangeList(rule.getKey()));
        this.modify();
    }

    private synchronized List<AbstractExchange> getExchangeList(RuleKey key) {
        ArrayList<AbstractExchange> c = new ArrayList<AbstractExchange>();
        for (AbstractExchange exc : this.inflight) {
            if (!exc.getRule().getKey().equals(key)) continue;
            c.add(exc);
        }
        for (AbstractExchange exc : this.exchanges) {
            if (!exc.getRule().getKey().equals(key)) continue;
            c.add(exc);
        }
        return c;
    }

    @Override
    public synchronized AbstractExchange[] getExchanges(RuleKey ruleKey) {
        return this.getExchangeList(ruleKey).toArray(new AbstractExchange[0]);
    }

    @Override
    public synchronized int getNumberOfExchanges(RuleKey ruleKey) {
        return this.getExchangeList(ruleKey).size();
    }

    @Override
    public synchronized StatisticCollector getStatistics(RuleKey key) {
        StatisticCollector statistics = new StatisticCollector(false);
        List<AbstractExchange> exchangesList = this.getExchangeList(key);
        if (exchangesList == null || exchangesList.isEmpty()) {
            return statistics;
        }
        for (int i = 0; i < exchangesList.size(); ++i) {
            statistics.collectFrom(exchangesList.get(i));
        }
        return statistics;
    }

    @Override
    public synchronized Object[] getAllExchanges() {
        return this.exchanges.toArray(new AbstractExchange[0]);
    }

    @Override
    public synchronized List<AbstractExchange> getAllExchangesAsList() {
        LinkedList<AbstractExchange> ret = new LinkedList<AbstractExchange>();
        for (AbstractExchange ex : this.inflight) {
            Request req = ex.getRequest();
            Exchange newEx = new Exchange(null);
            newEx.setId(ex.getId());
            newEx.setRequest(req);
            newEx.setRule(ex.getRule());
            newEx.setRemoteAddr(ex.getRemoteAddr());
            newEx.setTime(ex.getTime());
            newEx.setTimeReqSent(ex.getTimeReqSent() != 0L ? ex.getTimeReqSent() : ex.getTimeReqReceived());
            newEx.setTimeResReceived(System.currentTimeMillis());
            ret.add(newEx);
        }
        ret.addAll(this.exchanges);
        return ret;
    }

    @Override
    public synchronized void removeAllExchanges(AbstractExchange[] candidates) {
        this.exchanges.removeAll(Arrays.asList(candidates));
        this.modify();
    }

    @Override
    public synchronized AbstractExchange getExchangeById(long id) {
        return this.exchanges.stream().filter(exc -> exc.getId() == id).findAny().orElseGet(() -> this.inflight.stream().filter(exc -> exc.getId() == id).findAny().orElse(null));
    }

    @Override
    public synchronized List<? extends ClientStatistics> getClientStatistics() {
        HashMap<String, ClientStatisticsCollector> clients = new HashMap<String, ClientStatisticsCollector>();
        for (AbstractExchange exc : this.getAllExchangesAsList()) {
            if (!clients.containsKey(exc.getRemoteAddr())) {
                clients.put(exc.getRemoteAddr(), new ClientStatisticsCollector(exc.getRemoteAddr()));
            }
            ((ClientStatisticsCollector)clients.get(exc.getRemoteAddr())).collect(exc);
        }
        return new ArrayList(clients.values());
    }

    public synchronized int getCurrentSize() {
        return this.exchanges.stream().map(abstractExchange -> abstractExchange.getHeapSizeEstimation()).reduce(0, (a, b) -> a + b);
    }

    public synchronized Long getOldestTimeResSent() {
        AbstractExchange exc = this.exchanges.peek();
        return exc == null ? null : Long.valueOf(exc.getTimeResSent());
    }

    private synchronized void makeSpaceIfNeeded(AbstractExchange exc) {
        AbstractExchange removedExc;
        while (!this.hasEnoughSpace(exc) && (removedExc = this.exchanges.poll()) != null) {
            this.currentSize -= removedExc.getHeapSizeEstimation();
        }
    }

    private boolean hasEnoughSpace(AbstractExchange exc) {
        return exc.getHeapSizeEstimation() + this.getCurrentSize() <= this.maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @MCAttribute
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        if ((long)this.maxSize > Runtime.getRuntime().totalMemory() - 0x6400000L) {
            this.showWarningNotEnoughMemory();
        }
    }

    private void showWarningNotEnoughMemory() {
        String separator = "=========================================================================================";
        log.warn(separator);
        log.warn(separator);
        log.warn("You current LimitedMemoryExchangeStore max size is near the max available JVM heap space.");
        log.warn("LimitedMemoryExchangeStore max size: " + this.formatTwoDecimals(this.getLmesMaxSizeInMb()) + "mb");
        log.warn("Java Virtual Machine heap size: " + this.formatTwoDecimals(this.getJvmHeapSizeInMb()) + "mb");
        log.warn("Suggestion: add \"-Xmx" + Math.round(this.getLmesMaxSizeInMb() + 100.0f + 1.0f) + "m\" as additional parameter in the Membrane starter script");
        log.warn(separator);
        log.warn(separator);
    }

    private float getJvmHeapSizeInMb() {
        return (float)Runtime.getRuntime().totalMemory() / 1024.0f / 1024.0f;
    }

    private float getLmesMaxSizeInMb() {
        return (float)this.maxSize / 1024.0f / 1024.0f;
    }

    private String formatTwoDecimals(float number) {
        DecimalFormat formatter = new DecimalFormat("#.##");
        return formatter.format(number);
    }

    private synchronized void modify() {
        this.lastModification = System.currentTimeMillis();
        this.notifyAll();
    }

    @Override
    public synchronized long getLastModified() {
        return this.lastModification;
    }

    @Override
    public synchronized void waitForModification(long lastKnownModification) throws InterruptedException {
        while (lastKnownModification >= this.lastModification) {
            this.wait();
        }
        return;
    }

    public int getMaxBodySize() {
        return this.maxBodySize;
    }

    @MCAttribute
    public void setMaxBodySize(int maxBodySize) {
        this.maxBodySize = maxBodySize;
    }

    public BodyCollectingMessageObserver.Strategy getBodyExceedingMaxSizeStrategy() {
        return this.bodyExceedingMaxSizeStrategy;
    }

    @MCAttribute
    public void setBodyExceedingMaxSizeStrategy(BodyCollectingMessageObserver.Strategy bodyExceedingMaxSizeStrategy) {
        this.bodyExceedingMaxSizeStrategy = bodyExceedingMaxSizeStrategy;
    }
}

