/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.graphql.GraphQLParser;
import com.predic8.membrane.core.graphql.GraphQLValidator;
import com.predic8.membrane.core.graphql.model.ExecutableDocument;
import com.predic8.membrane.core.graphql.model.Field;
import com.predic8.membrane.core.graphql.model.FragmentDefinition;
import com.predic8.membrane.core.graphql.model.FragmentSpread;
import com.predic8.membrane.core.graphql.model.InlineFragment;
import com.predic8.membrane.core.graphql.model.OperationDefinition;
import com.predic8.membrane.core.graphql.model.Selection;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.http.HeaderName;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.util.URLParamUtil;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.ParseException;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="graphQLProtection")
public class GraphQLProtectionInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(GraphQLProtectionInterceptor.class);
    private final GraphQLParser graphQLParser = new GraphQLParser();
    private final ObjectMapper om = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, true).configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true);
    private boolean allowExtensions = false;
    private List<String> allowedMethods = Lists.newArrayList((Object[])new String[]{"GET", "POST"});
    private int maxRecursion = 3;
    private int maxDepth = 7;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        void var2_7;
        Object query;
        if (!this.allowedMethods.contains(exc.getRequest().getMethod())) {
            return this.error(exc, 405, "Invalid method.");
        }
        String rawQuery = this.router.getUriFactory().create(exc.getRequest().getUri()).getRawQuery();
        if ("GET".equals(exc.getRequest().getMethod())) {
            Map<String, String> map;
            if (rawQuery == null) {
                return this.error(exc, "No query parameters found.");
            }
            try {
                map = URLParamUtil.parseQueryString(rawQuery, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
            }
            catch (Exception e) {
                return this.error(exc, "Error decoding query string.");
            }
            if (map.containsKey("variables")) {
                map.put("variables", (String)this.om.readValue(map.get("variables"), Map.class));
            }
            if (map.containsKey("extensions")) {
                map.put("extensions", (String)this.om.readValue(map.get("extensions"), Map.class));
            }
        } else if ("POST".equals(exc.getRequest().getMethod())) {
            ContentType ct;
            List<HeaderField> contentType;
            if (rawQuery != null) {
                Map<String, String> params = URLParamUtil.parseQueryString(rawQuery, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
                for (String key : new String[]{"query", "operationName", "variables", "extensions"}) {
                    if (!params.containsKey(key)) continue;
                    return this.error(exc, "'" + key + "' is not allowed as query parameter while using POST.");
                }
            }
            if ((contentType = exc.getRequest().getHeader().getValues(new HeaderName("Content-Type"))).size() == 0) {
                return this.error(exc, "No 'Content-Type' found.");
            }
            if (contentType.size() > 1) {
                return this.error(exc, "Found multiple 'Content-Type' headers.");
            }
            try {
                ct = new ContentType(contentType.get(0).getValue());
            }
            catch (ParseException e) {
                return this.error(exc, "Could not parse 'Content-Type' header.");
            }
            if (ct.match("application/graphql")) {
                ImmutableMap immutableMap = ImmutableMap.of((Object)"query", (Object)exc.getRequest().getBodyAsStringDecoded());
            } else {
                if (!ct.match("application/json")) return this.error(exc, "Expected 'Content-Type: application/json' or 'Content-Type: application/graphql'.");
                String charset = ct.getParameter("charset");
                if (charset != null && !"utf-8".equalsIgnoreCase(charset)) {
                    return this.error(exc, "Invalid charset in 'Content-Type': Expected 'utf-8'.");
                }
                try {
                    Map map = (Map)this.om.readValue(exc.getRequest().getBodyAsStreamDecoded(), Map.class);
                }
                catch (JsonParseException e) {
                    return this.error(exc, "Error decoding JSON object.");
                }
            }
        } else {
            exc.setResponse(Response.methodNotAllowed().build());
            return Outcome.RETURN;
        }
        if ((query = var2_7.get("query")) == null) {
            return this.error(exc, "Parameter 'query' is missing.");
        }
        if (!(query instanceof String)) {
            return this.error(exc, "Expected 'query' to be of type 'String'.");
        }
        if (!this.allowExtensions && var2_7.containsKey("extensions") && var2_7.get("extensions") != null) {
            return this.error(exc, "GraphQL 'extensions' are forbidden.");
        }
        Object operationName = var2_7.get("operationName");
        if (operationName != null && !(operationName instanceof String)) {
            return this.error(exc, "Expected 'operationName' to be a String.");
        }
        Object variables = var2_7.get("variables");
        if (variables != null && !(variables instanceof Map)) {
            return this.error(exc, "Expected 'variables' to be a JSON Object.");
        }
        Object extensions = var2_7.get("extensions");
        if (extensions != null && !(extensions instanceof Map)) {
            return this.error(exc, "Expected 'extensions' to be a JSON Object.");
        }
        ExecutableDocument ed = this.graphQLParser.parseRequest(new ByteArrayInputStream(((String)query).getBytes(StandardCharsets.UTF_8)));
        List<String> e1 = new GraphQLValidator().validate(ed);
        if (e1 != null && e1.size() > 0) {
            return this.error(exc, e1.get(0));
        }
        if ("GET".equals(exc.getRequest().getMethod()) && ed.getExecutableDefinitions().stream().filter(exd -> exd instanceof OperationDefinition).map(exd -> (OperationDefinition)exd).anyMatch(od -> od.getOperationType() != null && !"query".equals(od.getOperationType().getOperation()))) {
            return this.error(exc, 405, "'GET' may only be used for GraphQL 'query's.");
        }
        OperationDefinition operationToExecute = null;
        if (operationName != null && !operationName.equals("")) {
            ods = ed.getExecutableDefinitions().stream().filter(exd -> exd instanceof OperationDefinition).map(exd -> (OperationDefinition)exd).filter(od -> operationName.equals(od.getName())).toList();
            if (ods.size() == 0) {
                return this.error(exc, "The operation named by 'operationName' could not be found.");
            }
            if (ods.size() > 1) {
                return this.error(exc, "Multiple OperationDefinitions with the same name in the GraphQL document.");
            }
            operationToExecute = ods.get(0);
        } else {
            ods = ed.getExecutableDefinitions().stream().filter(exd -> exd instanceof OperationDefinition).map(exd -> (OperationDefinition)exd).toList();
            if (ods.size() == 0) {
                return this.error(exc, "Could not find an OperationDefinition in the GraphQL document.");
            }
            if (ods.size() > 1) {
                return this.error(exc, "Multiple OperationDefinitions with the same name in the GraphQL document.");
            }
            operationToExecute = ods.get(0);
        }
        String depthOrRecursionError = this.getDepthOrRecursionError(ed, operationToExecute);
        if (depthOrRecursionError == null) return Outcome.CONTINUE;
        return this.error(exc, depthOrRecursionError);
    }

    private String getDepthOrRecursionError(ExecutableDocument ed, OperationDefinition od) {
        String err = this.checkSelections(ed, od, od.getSelections(), new ArrayList<String>(), new HashSet<String>());
        if (err != null) {
            return err;
        }
        return null;
    }

    private String checkSelections(ExecutableDocument ed, OperationDefinition od, List<Selection> selections, List<String> fieldStack, HashSet<String> fragmentNamesVisited) {
        if (selections == null) {
            return null;
        }
        for (Selection selection : selections) {
            if (selection == null) {
                LOG.error("Selection is null.");
                return "See server log.";
            }
            String err = selection instanceof Field ? this.checkField((Field)selection, ed, od, selections, fieldStack, fragmentNamesVisited) : (selection instanceof FragmentSpread ? this.checkFragmentSpread((FragmentSpread)selection, ed, od, selections, fieldStack, fragmentNamesVisited) : (selection instanceof InlineFragment ? this.checkSelections(ed, od, ((InlineFragment)selection).getSelections(), fieldStack, fragmentNamesVisited) : this.checkUnhandled(selection)));
            if (err == null) continue;
            return err;
        }
        return null;
    }

    private String checkUnhandled(Selection selection) {
        LOG.error("Unhandled class: " + selection.getClass().getName());
        return "See server log.";
    }

    private String checkFragmentSpread(FragmentSpread fragmentSpread, ExecutableDocument ed, OperationDefinition od, List<Selection> selections, List<String> fieldStack, HashSet<String> fragmentNamesVisited) {
        String fragmentName = fragmentSpread.getFragmentName();
        Optional<FragmentDefinition> fragment = ed.getExecutableDefinitions().stream().filter(ed2 -> ed2 instanceof FragmentDefinition).map(ed2 -> (FragmentDefinition)ed2).filter(ed2 -> fragmentName.equals(ed2.getName())).findAny();
        if (fragment.isEmpty()) {
            return "Did not find fragment '" + fragmentName + "'.";
        }
        if (!fragmentNamesVisited.add(fragmentName)) {
            return "Fragment spreads form cycle ('" + fragmentName + "').";
        }
        String err = this.checkSelections(ed, od, fragment.get().getSelections(), fieldStack, fragmentNamesVisited);
        if (err != null) {
            return err;
        }
        fragmentNamesVisited.remove(fragmentName);
        return null;
    }

    private String checkField(Field field, ExecutableDocument ed, OperationDefinition od, List<Selection> selections, List<String> fieldStack, HashSet<String> fragmentNamesVisited) {
        String fieldName = field.getName();
        fieldStack.add(fieldName);
        if (fieldStack.size() > this.maxDepth) {
            return "Max depth exceeded.";
        }
        if (fieldStack.stream().filter(name -> name.equals(fieldName)).count() > (long)this.maxRecursion) {
            return "Max recursion exceeded.";
        }
        String err = this.checkSelections(ed, od, field.getSelections(), fieldStack, fragmentNamesVisited);
        if (err != null) {
            return err;
        }
        fieldStack.remove(fieldStack.size() - 1);
        return null;
    }

    private Outcome error(Exchange exc, String message) {
        LOG.warn(message);
        exc.setResponse(Response.badRequest().build());
        return Outcome.RETURN;
    }

    private Outcome error(Exchange exc, int code, String message) {
        LOG.warn(message);
        exc.setResponse(Response.badRequest().status(code).build());
        return Outcome.RETURN;
    }

    public boolean isAllowExtensions() {
        return this.allowExtensions;
    }

    @MCAttribute
    public void setAllowExtensions(boolean allowExtensions) {
        this.allowExtensions = allowExtensions;
    }

    public String getAllowedMethods() {
        return String.join((CharSequence)",", this.allowedMethods);
    }

    @MCAttribute
    public void setAllowedMethods(String allowedMethods) {
        this.allowedMethods = Arrays.asList(allowedMethods.split(","));
        for (String allowedMethod : this.allowedMethods) {
            if ("GET".equals(allowedMethod) || "POST".equals(allowedMethod)) continue;
            throw new InvalidParameterException("<graphQLProtectionInterceptor allowedMethods=\"...\" /> may only allow GET or POST.");
        }
    }

    public int getMaxRecursion() {
        return this.maxRecursion;
    }

    @MCAttribute
    public void setMaxRecursion(int maxRecursion) {
        this.maxRecursion = maxRecursion;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    @MCAttribute
    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }
}

