/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql;

import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.Argument;
import com.predic8.membrane.core.graphql.model.BooleanValue;
import com.predic8.membrane.core.graphql.model.Directive;
import com.predic8.membrane.core.graphql.model.EnumValue;
import com.predic8.membrane.core.graphql.model.FieldDefinition;
import com.predic8.membrane.core.graphql.model.FloatValue;
import com.predic8.membrane.core.graphql.model.InputValueDefinition;
import com.predic8.membrane.core.graphql.model.IntValue;
import com.predic8.membrane.core.graphql.model.ListType;
import com.predic8.membrane.core.graphql.model.ListValue;
import com.predic8.membrane.core.graphql.model.NamedType;
import com.predic8.membrane.core.graphql.model.NullValue;
import com.predic8.membrane.core.graphql.model.ObjectValue;
import com.predic8.membrane.core.graphql.model.Selection;
import com.predic8.membrane.core.graphql.model.StringValue;
import com.predic8.membrane.core.graphql.model.Type;
import com.predic8.membrane.core.graphql.model.Value;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ParserUtil {
    public static String parseName(Tokenizer t) throws IOException, ParsingException {
        t.mustAdvance();
        if (t.type() != Tokenizer.Type.NAME) {
            throw new ParsingException("Expected name.", t.position());
        }
        return t.string();
    }

    public static List<InputValueDefinition> parseOptionalArgumentsDefinition(Tokenizer t) throws IOException, ParsingException {
        if (t.type() != Tokenizer.Type.PUNCTUATOR || t.punctuator() != 40) {
            return null;
        }
        ArrayList<InputValueDefinition> res = new ArrayList<InputValueDefinition>();
        t.mustAdvance();
        while (t.type() != Tokenizer.Type.PUNCTUATOR || t.punctuator() != 41) {
            InputValueDefinition ivd = new InputValueDefinition();
            ivd.parse(t);
            res.add(ivd);
            t.mustAdvance();
        }
        return res;
    }

    public static List<Argument> parseOptionalArguments(Tokenizer t) throws IOException, ParsingException {
        if (t.type() != Tokenizer.Type.PUNCTUATOR || t.punctuator() != 40) {
            return null;
        }
        ArrayList<Argument> res = new ArrayList<Argument>();
        t.mustAdvance();
        while (t.type() != Tokenizer.Type.PUNCTUATOR || t.punctuator() != 41) {
            Argument a = new Argument();
            a.parse(t);
            res.add(a);
            t.mustAdvance();
        }
        return res;
    }

    public static List<Directive> parseDirectivesConstOpt(Tokenizer t) throws IOException, ParsingException {
        if (t.type() != Tokenizer.Type.PUNCTUATOR || t.punctuator() != 64) {
            return null;
        }
        ArrayList<Directive> res = new ArrayList<Directive>();
        while (t.type() == Tokenizer.Type.PUNCTUATOR && t.punctuator() == 64) {
            Directive d = new Directive();
            d.parse(t);
            res.add(d);
            if (t.advance()) continue;
            break;
        }
        t.revert();
        return res;
    }

    public static Type parseType(Tokenizer tokenizer) throws IOException, ParsingException {
        Type res;
        if (tokenizer.type() == Tokenizer.Type.PUNCTUATOR && tokenizer.punctuator() == 91) {
            res = new ListType();
            res.parse(tokenizer);
        } else if (tokenizer.type() == Tokenizer.Type.NAME) {
            res = new NamedType();
            res.parse(tokenizer);
        } else {
            throw new ParsingException("Expected type.", tokenizer.position());
        }
        return res;
    }

    public static Value parseValueQuestionConst(Tokenizer tokenizer) throws IOException, ParsingException {
        Value value = null;
        if (tokenizer.type() == Tokenizer.Type.STRING_VALUE) {
            value = new StringValue();
        }
        if (tokenizer.type() == Tokenizer.Type.INT_VALUE) {
            value = new IntValue();
        }
        if (tokenizer.type() == Tokenizer.Type.FLOAT_VALUE) {
            value = new FloatValue();
        }
        if (tokenizer.type() == Tokenizer.Type.NAME) {
            String name = tokenizer.string();
            value = "true".equals(name) || "false".equals(name) ? new BooleanValue() : ("null".equals(name) ? new NullValue() : new EnumValue());
        }
        if (tokenizer.type() == Tokenizer.Type.PUNCTUATOR) {
            if (tokenizer.punctuator() == 91) {
                value = new ListValue();
            }
            if (tokenizer.punctuator() == 123) {
                value = new ObjectValue();
            }
        }
        if (value == null) {
            throw new ParsingException("not implemented : " + tokenizer.tokenString(), tokenizer.position());
        }
        value.parse(tokenizer);
        return value;
    }

    public static Value parseValueConst(Tokenizer tokenizer) throws IOException, ParsingException {
        return ParserUtil.parseValueQuestionConst(tokenizer);
    }

    public static List<Directive> parseDirectivesOpt(Tokenizer tokenizer) throws ParsingException, IOException {
        return ParserUtil.parseDirectivesConstOpt(tokenizer);
    }

    public static List<FieldDefinition> parseFieldsDefinition(Tokenizer tokenizer) throws IOException, ParsingException {
        tokenizer.mustAdvance();
        ArrayList<FieldDefinition> res = new ArrayList<FieldDefinition>();
        do {
            if (tokenizer.type() == Tokenizer.Type.PUNCTUATOR && tokenizer.punctuator() == 125) {
                return res;
            }
            FieldDefinition fd = new FieldDefinition();
            fd.parse(tokenizer);
            res.add(fd);
        } while (tokenizer.advance());
        throw new ParsingException("Expected '}'.", tokenizer.position());
    }

    public static List<NamedType> parseImplements(Tokenizer tokenizer) throws IOException, ParsingException {
        tokenizer.mustAdvance();
        if (tokenizer.type() == Tokenizer.Type.PUNCTUATOR && tokenizer.punctuator() == 38) {
            tokenizer.mustAdvance();
        }
        ArrayList<NamedType> res = new ArrayList<NamedType>();
        while (true) {
            NamedType type = new NamedType();
            type.parse(tokenizer);
            if (type.isNullable()) {
                throw new ParsingException("Nullable types are not supported in 'implements'.", tokenizer.position());
            }
            res.add(type);
            tokenizer.mustAdvance();
            if (tokenizer.type() != Tokenizer.Type.PUNCTUATOR || tokenizer.punctuator() != 38) break;
            tokenizer.mustAdvance();
        }
        return res;
    }

    public static List<NamedType> parseUnionMemberTypes(Tokenizer tokenizer) throws IOException, ParsingException {
        tokenizer.mustAdvance();
        if (tokenizer.type() == Tokenizer.Type.PUNCTUATOR && tokenizer.punctuator() == 124) {
            tokenizer.mustAdvance();
        }
        ArrayList<NamedType> res = new ArrayList<NamedType>();
        while (true) {
            NamedType type = new NamedType();
            type.parse(tokenizer);
            if (type.isNullable()) {
                throw new ParsingException("Nullable types are not supported in 'union'.", tokenizer.position());
            }
            res.add(type);
            if (!tokenizer.advance() || tokenizer.type() != Tokenizer.Type.PUNCTUATOR || tokenizer.punctuator() != 124) break;
            tokenizer.mustAdvance();
        }
        return res;
    }

    public static List<Selection> parseSelectionSetOpt(Tokenizer t) throws IOException, ParsingException {
        if (t.type() != Tokenizer.Type.PUNCTUATOR || t.punctuator() != 123) {
            return null;
        }
        ArrayList<Selection> res = new ArrayList<Selection>();
        t.mustAdvance();
        while (t.type() != Tokenizer.Type.PUNCTUATOR || t.punctuator() != 125) {
            Selection a = Selection.parseSelection(t);
            res.add(a);
            t.mustAdvance();
        }
        return res;
    }
}

