/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql;

import com.predic8.membrane.core.graphql.CountingReader;
import com.predic8.membrane.core.graphql.ParsingException;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.io.input.BOMInputStream;

public class Tokenizer {
    private final CountingReader reader;
    private Type type;
    private int intValue;
    private double doubleValue;
    private String stringValue;
    private boolean reverted;
    private boolean eof;

    public Tokenizer(InputStream reader) {
        this.reader = new CountingReader(new BufferedReader(new InputStreamReader((InputStream)new BOMInputStream(reader))));
    }

    public void revert() {
        if (this.reverted) {
            throw new IllegalStateException("Cannot double-revert().");
        }
        this.reverted = true;
    }

    public void mustAdvance() throws IOException, ParsingException {
        if (!this.advance()) {
            throw new ParsingException("Early EOF.", this.position());
        }
    }

    public boolean advance() throws IOException, ParsingException {
        if (this.reverted) {
            this.reverted = false;
            return !this.eof;
        }
        while (true) {
            int c;
            if ((c = this.reader.read()) == -1) {
                this.type = null;
                this.eof = true;
                return false;
            }
            if (c == 33 || c == 36 || c == 38 || c == 40 || c == 41 || c == 58 || c == 61 || c == 64 || c == 91 || c == 93 || c == 123 || c == 124 || c == 125) {
                this.type = Type.PUNCTUATOR;
                this.intValue = c;
                return true;
            }
            if (c == 46) {
                this.reader.mark(2);
                if (this.reader.read() != 46 || this.reader.read() != 46) {
                    throw new ParsingException("Expected punctuator '...'", this.reader.position());
                }
                this.type = Type.PUNCTUATOR;
                this.intValue = c;
                return true;
            }
            if (this.isNameStart(c)) {
                this.parseName(c);
                return true;
            }
            if (c == 45 || 48 <= c && c <= 57) {
                this.parseIntOrFloat(c);
                return true;
            }
            if (c == 34) {
                this.type = Type.STRING_VALUE;
                c = this.reader.read();
                if (c == -1) {
                    throw new EOFException();
                }
                if (c == 34) {
                    this.reader.mark(2);
                    c = this.reader.read();
                    if (c != 34) {
                        this.reader.reset();
                        this.stringValue = "";
                        return true;
                    }
                    this.parseBlockString();
                    return true;
                }
                this.parseSimpleString(c);
                return true;
            }
            if (c == 9 || c == 32 || c == 10) continue;
            if (c == 13) {
                this.reader.mark(1);
                c = this.reader.read();
                if (c == 10) continue;
                this.reader.reset();
                continue;
            }
            if (c == 35) {
                this.parseComment();
                continue;
            }
            if (c != 44) break;
        }
        throw new ParsingException("Illegal char.", this.reader.position());
    }

    private void parseComment() throws IOException, ParsingException {
        int c;
        do {
            this.reader.mark(1);
            c = this.reader.read();
            if (c == -1) {
                return;
            }
            if (c != 13 && c != 10) continue;
            this.reader.reset();
            return;
        } while (this.isSourceChar(c));
        throw new ParsingException("Invalid char.", this.reader.position());
    }

    private boolean isNameStart(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 95;
    }

    private void parseBlockString() throws IOException, ParsingException {
        StringBuilder value2 = new StringBuilder();
        while (true) {
            int c;
            if ((c = this.reader.read()) == -1) {
                throw new EOFException();
            }
            if (!this.isSourceChar(c)) {
                throw new ParsingException("Invalid character in block string.", this.reader.position());
            }
            if (c == 34) {
                this.reader.mark(2);
                if (this.reader.read() == 34 && this.reader.read() == 34) break;
                this.reader.reset();
            }
            if (c == 92) {
                this.reader.mark(3);
                if (this.reader.read() == 34 && this.reader.read() == 34 && this.reader.read() == 34) {
                    value2.append("\"\"\"");
                    continue;
                }
                this.reader.reset();
                value2.append("\\");
                continue;
            }
            value2.append((char)c);
        }
        this.stringValue = value2.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSimpleString(int c) throws IOException, ParsingException {
        StringBuilder value = new StringBuilder();
        do {
            if (!this.isSourceChar(c)) {
                throw new ParsingException("Found illegal character.", this.reader.position());
            }
            if (c == 13 || c == 10) {
                throw new ParsingException("Found newline while parsing string.", this.reader.position());
            }
            if (c == 92) {
                c = this.reader.read();
                if (c == -1) {
                    throw new EOFException();
                }
                if (c == 34 || c == 92 || c == 47) {
                    value.append((char)c);
                } else if (c == 110) {
                    value.append('\n');
                } else if (c == 114) {
                    value.append('\r');
                } else if (c == 116) {
                    value.append('\t');
                } else if (c == 98) {
                    value.append('\b');
                } else if (c == 102) {
                    value.append('\f');
                } else {
                    if (c != 117) throw new ParsingException("Invalid escaped character '" + c + "'", this.reader.position());
                    value.append((char)Integer.parseInt("" + this.assertHex(this.reader.read()) + this.assertHex(this.reader.read()) + this.assertHex(this.reader.read()) + this.assertHex(this.reader.read()), 16));
                }
            } else {
                value.append((char)c);
            }
            c = this.reader.read();
            if (c != -1) continue;
            throw new EOFException();
        } while (c != 34);
        this.stringValue = value.toString();
    }

    private void parseIntOrFloat(int c) throws IOException {
        boolean hasExp;
        boolean hasDot;
        StringBuilder sb;
        block5: {
            sb = new StringBuilder();
            hasDot = false;
            hasExp = false;
            do {
                sb.append((char)c);
                this.reader.mark(2);
                c = this.reader.read();
                if (!hasDot && c == 46) {
                    c = this.reader.read();
                    if (this.isNameStart(c)) {
                        this.reader.reset();
                        break block5;
                    }
                    hasDot = true;
                    sb.append('.');
                }
                if (hasExp || c != 101 && c != 69) continue;
                hasExp = true;
                sb.append((char)c);
                c = this.reader.read();
                if (c != 43 && c != 45) continue;
                sb.append((char)c);
                c = this.reader.read();
            } while (48 <= c && c <= 57);
            this.reader.reset();
        }
        Type type = this.type = hasDot || hasExp ? Type.FLOAT_VALUE : Type.INT_VALUE;
        if (this.type == Type.INT_VALUE) {
            this.intValue = Integer.parseInt(sb.toString());
        } else {
            this.doubleValue = Double.parseDouble(sb.toString());
        }
    }

    private void parseName(int c) throws IOException {
        this.type = Type.NAME;
        StringBuilder value3 = new StringBuilder();
        do {
            value3.append((char)c);
            this.reader.mark(1);
            c = this.reader.read();
        } while (c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 95 || 48 <= c && c <= 57);
        this.reader.reset();
        this.stringValue = value3.toString();
    }

    private char assertHex(int c) throws EOFException, ParsingException {
        if (c == -1) {
            throw new EOFException();
        }
        if (48 <= c && c <= 57 || 97 <= c && c <= 102 || 65 <= c && c <= 70) {
            return (char)c;
        }
        throw new ParsingException("Illegal hex character in escaped string char.", this.reader.position());
    }

    private boolean isSourceChar(int c) {
        return c == 9 || c == 10 || c == 13 || c >= 32;
    }

    public Type type() {
        if (this.reverted) {
            throw new IllegalStateException();
        }
        if (this.eof) {
            throw new IllegalStateException();
        }
        return this.type;
    }

    public int punctuator() {
        if (this.type != Type.PUNCTUATOR && this.type != Type.INT_VALUE) {
            throw new IllegalStateException();
        }
        if (this.reverted) {
            throw new IllegalStateException();
        }
        if (this.eof) {
            throw new IllegalStateException();
        }
        return this.intValue;
    }

    public String string() {
        if (this.type != Type.NAME && this.type != Type.STRING_VALUE) {
            throw new IllegalStateException();
        }
        if (this.reverted) {
            throw new IllegalStateException();
        }
        if (this.eof) {
            throw new IllegalStateException();
        }
        return this.stringValue;
    }

    public int integer() {
        if (this.type != Type.PUNCTUATOR && this.type != Type.INT_VALUE) {
            throw new IllegalStateException();
        }
        if (this.reverted) {
            throw new IllegalStateException();
        }
        if (this.eof) {
            throw new IllegalStateException();
        }
        return this.intValue;
    }

    public double float_() {
        if (this.type != Type.FLOAT_VALUE) {
            throw new IllegalStateException();
        }
        if (this.reverted) {
            throw new IllegalStateException();
        }
        if (this.eof) {
            throw new IllegalStateException();
        }
        return this.doubleValue;
    }

    public String tokenString() {
        return switch (this.type()) {
            default -> throw new IncompatibleClassChangeError();
            case Type.PUNCTUATOR -> "PUNCTUATOR " + (char)this.punctuator() + " " + this.punctuator();
            case Type.INT_VALUE -> "INT_VALUE " + this.integer();
            case Type.FLOAT_VALUE -> "FLOAT_VALUE " + this.float_();
            case Type.NAME -> "NAME " + this.string();
            case Type.STRING_VALUE -> "STRING_VALUE " + this.string();
        };
    }

    public long position() {
        return this.reader.position();
    }

    public static enum Type {
        PUNCTUATOR,
        NAME,
        INT_VALUE,
        FLOAT_VALUE,
        STRING_VALUE;

    }
}

