/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParserUtil;
import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.Directive;
import com.predic8.membrane.core.graphql.model.EnumValue;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class EnumValueDefinition {
    private String description;
    private EnumValue value;
    private List<Directive> directives;

    public EnumValueDefinition() {
    }

    public EnumValueDefinition(String description, EnumValue value, List<Directive> directives) {
        this.description = description;
        this.value = value;
        this.directives = directives;
    }

    public void parse(Tokenizer tokenizer) throws IOException, ParsingException {
        if (tokenizer.type() == Tokenizer.Type.STRING_VALUE) {
            this.description = tokenizer.string();
            tokenizer.mustAdvance();
        }
        if (tokenizer.type() != Tokenizer.Type.NAME) {
            throw new ParsingException("Expected name.", tokenizer.position());
        }
        this.value = new EnumValue();
        this.value.parse(tokenizer);
        if (!tokenizer.advance()) {
            return;
        }
        this.directives = ParserUtil.parseDirectivesConstOpt(tokenizer);
        if (this.directives == null) {
            tokenizer.revert();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumValueDefinition that = (EnumValueDefinition)o;
        return Objects.equals(this.description, that.description) && Objects.equals(this.value, that.value) && Objects.equals(this.directives, that.directives);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.value, this.directives);
    }

    public String toString() {
        return "EnumValueDefinition{description='" + this.description + "', value='" + this.value + "', directives=" + this.directives + "}";
    }
}

