/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.ExecutableDefinition;
import com.predic8.membrane.core.graphql.model.FragmentDefinition;
import com.predic8.membrane.core.graphql.model.OperationDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ExecutableDocument {
    List<ExecutableDefinition> executableDefinitions = new ArrayList<ExecutableDefinition>();

    public ExecutableDocument() {
    }

    public ExecutableDocument(ExecutableDefinition ... executableDefinitions) {
        this.executableDefinitions.addAll(Arrays.asList(executableDefinitions));
    }

    public void parse(Tokenizer t) throws IOException, ParsingException {
        boolean shortHandQuery = false;
        while (t.advance()) {
            OperationDefinition od;
            if (t.type() == Tokenizer.Type.NAME) {
                if (t.string().equals("query") || t.string().equals("mutation") || t.string().equals("subscription")) {
                    od = new OperationDefinition();
                    od.parse(t);
                    this.executableDefinitions.add(od);
                    continue;
                }
                if (t.string().equals("fragment")) {
                    FragmentDefinition fd = new FragmentDefinition();
                    fd.parse(t);
                    this.executableDefinitions.add(fd);
                    continue;
                }
            }
            if (this.executableDefinitions.size() == 0 && !shortHandQuery) {
                od = new OperationDefinition();
                od.parse(t);
                this.executableDefinitions.add(od);
                shortHandQuery = true;
                continue;
            }
            throw new ParsingException("Expected 'query', 'mutation', 'subscription' or 'fragment'.", t.position());
        }
        if (shortHandQuery && this.executableDefinitions.size() != 1) {
            throw new ParsingException("The 'query' keyword may only be omitted, if there is exactly one query present in the ExecutableDocument.", t.position());
        }
        List<OperationDefinition> operations = this.executableDefinitions.stream().filter(ed -> ed instanceof OperationDefinition).map(ed -> (OperationDefinition)ed).toList();
        if (operations.size() > 1) {
            for (OperationDefinition op : operations) {
                if (op.getName() != null) continue;
                throw new ParsingException("Multiple queries must all be named.", t.position());
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutableDocument that = (ExecutableDocument)o;
        return Objects.equals(this.executableDefinitions, that.executableDefinitions);
    }

    public int hashCode() {
        return Objects.hash(this.executableDefinitions);
    }

    public String toString() {
        return "ExecutableDocument{executableDefinitions=" + this.executableDefinitions + "}";
    }

    public List<ExecutableDefinition> getExecutableDefinitions() {
        return this.executableDefinitions;
    }
}

