/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParserUtil;
import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.Argument;
import com.predic8.membrane.core.graphql.model.Directive;
import com.predic8.membrane.core.graphql.model.Selection;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class Field
extends Selection {
    String alias;
    String name;
    List<Argument> arguments;
    List<Directive> directives;
    List<Selection> selections;

    public Field() {
    }

    public Field(String name, List<Selection> selections) {
        this.name = name;
        this.selections = selections;
    }

    public Field(String alias, String name, List<Argument> arguments, List<Directive> directives, List<Selection> selections) {
        this.alias = alias;
        this.name = name;
        this.arguments = arguments;
        this.directives = directives;
        this.selections = selections;
    }

    @Override
    public void parse(Tokenizer tokenizer) throws IOException, ParsingException {
        if (tokenizer.type() != Tokenizer.Type.NAME) {
            throw new ParsingException("Expected name.", tokenizer.position());
        }
        String s = tokenizer.string();
        if (!tokenizer.advance()) {
            this.name = s;
            return;
        }
        if (tokenizer.type() == Tokenizer.Type.PUNCTUATOR && tokenizer.punctuator() == 58) {
            this.alias = s;
            tokenizer.mustAdvance();
            if (tokenizer.type() != Tokenizer.Type.NAME) {
                throw new ParsingException("Expected name.", tokenizer.position());
            }
            this.name = tokenizer.string();
            if (!tokenizer.advance()) {
                return;
            }
        } else {
            this.name = s;
        }
        this.arguments = ParserUtil.parseOptionalArguments(tokenizer);
        if (this.arguments != null && !tokenizer.advance()) {
            return;
        }
        this.directives = ParserUtil.parseDirectivesOpt(tokenizer);
        if (this.directives != null && !tokenizer.advance()) {
            return;
        }
        this.selections = ParserUtil.parseSelectionSetOpt(tokenizer);
        if (this.selections == null) {
            tokenizer.revert();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field field = (Field)o;
        return Objects.equals(this.alias, field.alias) && Objects.equals(this.name, field.name) && Objects.equals(this.arguments, field.arguments) && Objects.equals(this.directives, field.directives) && Objects.equals(this.selections, field.selections);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.name, this.arguments, this.directives, this.selections);
    }

    public String toString() {
        return "Field{alias='" + this.alias + "', name='" + this.name + "', arguments=" + this.arguments + ", directives=" + this.directives + ", selections=" + this.selections + "}";
    }

    public String getName() {
        return this.name;
    }

    public List<Selection> getSelections() {
        return this.selections;
    }
}

