/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParserUtil;
import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.Directive;
import com.predic8.membrane.core.graphql.model.ExecutableDefinition;
import com.predic8.membrane.core.graphql.model.Selection;
import com.predic8.membrane.core.graphql.model.Type;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class FragmentDefinition
extends ExecutableDefinition {
    String name;
    Type condition;
    List<Directive> directives;
    List<Selection> selections;

    public FragmentDefinition() {
    }

    public FragmentDefinition(String name, Type condition, List<Directive> directives, List<Selection> selections) {
        this.name = name;
        this.condition = condition;
        this.directives = directives;
        this.selections = selections;
    }

    @Override
    public void parse(Tokenizer tokenizer) throws IOException, ParsingException {
        this.name = ParserUtil.parseName(tokenizer);
        if ("on".equals(this.name)) {
            throw new ParsingException("Fragment name may not be 'on'.", tokenizer.position());
        }
        tokenizer.mustAdvance();
        if (tokenizer.type() == Tokenizer.Type.NAME && tokenizer.string().equals("on")) {
            tokenizer.mustAdvance();
            this.condition = ParserUtil.parseType(tokenizer);
            tokenizer.mustAdvance();
        }
        this.directives = ParserUtil.parseDirectivesOpt(tokenizer);
        if (this.directives != null) {
            tokenizer.mustAdvance();
        }
        if (tokenizer.type() != Tokenizer.Type.PUNCTUATOR || tokenizer.punctuator() != 123) {
            throw new ParsingException("Expected '{'.", tokenizer.position());
        }
        this.selections = ParserUtil.parseSelectionSetOpt(tokenizer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentDefinition that = (FragmentDefinition)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.condition, that.condition) && Objects.equals(this.directives, that.directives) && Objects.equals(this.selections, that.selections);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.condition, this.directives, this.selections);
    }

    public String toString() {
        return "FragmentDefinition{name='" + this.name + "', condition=" + this.condition + ", directives=" + this.directives + ", selections=" + this.selections + "}";
    }

    public String getName() {
        return this.name;
    }

    public List<Selection> getSelections() {
        return this.selections;
    }
}

