/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParserUtil;
import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.Directive;
import com.predic8.membrane.core.graphql.model.FieldDefinition;
import com.predic8.membrane.core.graphql.model.NamedType;
import com.predic8.membrane.core.graphql.model.TypeSystemDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ObjectTypeDefinition
implements TypeSystemDefinition {
    private String description;
    private String name;
    private List<NamedType> implementsInterfaces;
    private List<Directive> directives;
    private List<FieldDefinition> fieldDefinitions = new ArrayList<FieldDefinition>();

    public ObjectTypeDefinition() {
    }

    public ObjectTypeDefinition(String description, String name, List<NamedType> implementsInterfaces, List<Directive> directives, List<FieldDefinition> fieldDefinitions) {
        this.description = description;
        this.name = name;
        this.implementsInterfaces = implementsInterfaces;
        this.directives = directives;
        this.fieldDefinitions = fieldDefinitions;
    }

    @Override
    public void parse(Tokenizer tokenizer) throws IOException, ParsingException {
        this.name = ParserUtil.parseName(tokenizer);
        if (!tokenizer.advance()) {
            return;
        }
        if (tokenizer.type() == Tokenizer.Type.NAME && tokenizer.string().equals("implements")) {
            this.implementsInterfaces = ParserUtil.parseImplements(tokenizer);
        }
        this.directives = ParserUtil.parseDirectivesConstOpt(tokenizer);
        if (this.directives != null && !tokenizer.advance()) {
            return;
        }
        if (tokenizer.type() == Tokenizer.Type.PUNCTUATOR && tokenizer.integer() == 123) {
            this.fieldDefinitions = ParserUtil.parseFieldsDefinition(tokenizer);
            return;
        }
        tokenizer.revert();
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectTypeDefinition that = (ObjectTypeDefinition)o;
        return Objects.equals(this.description, that.description) && Objects.equals(this.name, that.name) && Objects.equals(this.implementsInterfaces, that.implementsInterfaces) && Objects.equals(this.directives, that.directives) && Objects.equals(this.fieldDefinitions, that.fieldDefinitions);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.name, this.implementsInterfaces, this.directives, this.fieldDefinitions);
    }

    public String toString() {
        return "ObjectTypeDefinition{description='" + this.description + "', name='" + this.name + "', implementsInterfaces=" + this.implementsInterfaces + ", directives=" + this.directives + ", fieldDefinitions=" + this.fieldDefinitions + "}";
    }
}

