/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParserUtil;
import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.Directive;
import com.predic8.membrane.core.graphql.model.ExecutableDefinition;
import com.predic8.membrane.core.graphql.model.OperationType;
import com.predic8.membrane.core.graphql.model.Selection;
import com.predic8.membrane.core.graphql.model.VariableDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OperationDefinition
extends ExecutableDefinition {
    OperationType operationType;
    String name;
    List<VariableDefinition> variableDefinitions;
    List<Directive> directives;
    List<Selection> selections;

    public OperationDefinition() {
    }

    public OperationDefinition(OperationType operationType, String name, List<VariableDefinition> variableDefinitions, List<Directive> directives, List<Selection> selections) {
        this.operationType = operationType;
        this.name = name;
        this.variableDefinitions = variableDefinitions;
        this.directives = directives;
        this.selections = selections;
    }

    @Override
    public void parse(Tokenizer tokenizer) throws IOException, ParsingException {
        if (tokenizer.type() == Tokenizer.Type.NAME && OperationType.is(tokenizer.string())) {
            this.operationType = new OperationType();
            this.operationType.parse(tokenizer);
            tokenizer.mustAdvance();
            if (tokenizer.type() == Tokenizer.Type.NAME) {
                this.name = tokenizer.string();
                tokenizer.mustAdvance();
            }
            this.variableDefinitions = OperationDefinition.parseVariableDefinitionsOpt(tokenizer);
            if (this.variableDefinitions != null) {
                tokenizer.mustAdvance();
            }
            this.directives = ParserUtil.parseDirectivesOpt(tokenizer);
            if (this.directives != null) {
                tokenizer.mustAdvance();
            }
            if (tokenizer.type() != Tokenizer.Type.PUNCTUATOR || tokenizer.punctuator() != 123) {
                throw new ParsingException("Expected '{'.", tokenizer.position());
            }
        } else if (tokenizer.type() != Tokenizer.Type.PUNCTUATOR || tokenizer.punctuator() != 123) {
            throw new ParsingException("Expected 'query', 'mutation', 'subscription' or '{'.", tokenizer.position());
        }
        this.selections = ParserUtil.parseSelectionSetOpt(tokenizer);
    }

    public static List<VariableDefinition> parseVariableDefinitionsOpt(Tokenizer t) throws IOException, ParsingException {
        if (t.type() != Tokenizer.Type.PUNCTUATOR || t.punctuator() != 40) {
            return null;
        }
        ArrayList<VariableDefinition> res = new ArrayList<VariableDefinition>();
        t.mustAdvance();
        do {
            VariableDefinition a = new VariableDefinition();
            a.parse(t);
            res.add(a);
            t.mustAdvance();
        } while (t.type() != Tokenizer.Type.PUNCTUATOR || t.punctuator() != 41);
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationDefinition that = (OperationDefinition)o;
        return Objects.equals(this.operationType, that.operationType) && Objects.equals(this.name, that.name) && Objects.equals(this.variableDefinitions, that.variableDefinitions) && Objects.equals(this.directives, that.directives) && Objects.equals(this.selections, that.selections);
    }

    public int hashCode() {
        return Objects.hash(this.operationType, this.name, this.variableDefinitions, this.directives, this.selections);
    }

    public String toString() {
        return "OperationDefinition{operationType=" + this.operationType + ", name='" + this.name + "', variableDefinitions=" + this.variableDefinitions + ", directives=" + this.directives + ", selections=" + this.selections + "}";
    }

    public String getName() {
        return this.name;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public List<Selection> getSelections() {
        return this.selections;
    }
}

