/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import java.security.InvalidParameterException;
import java.util.Objects;

public class OperationType {
    private String operation;

    public OperationType() {
    }

    public OperationType(String operation) {
        this.operation = operation;
        if (!OperationType.is(operation)) {
            throw new InvalidParameterException();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationType that = (OperationType)o;
        return Objects.equals(this.operation, that.operation);
    }

    public int hashCode() {
        return Objects.hash(this.operation);
    }

    public String toString() {
        return "OperationType{operation='" + this.operation + "'}";
    }

    public void parse(Tokenizer tokenizer) throws ParsingException {
        this.operation = tokenizer.string();
        if (!OperationType.is(this.operation)) {
            throw new ParsingException("Invalid OperationType.", tokenizer.position());
        }
    }

    public static boolean is(String operation) {
        return operation.equals("query") || operation.equals("mutation") || operation.equals("subscription");
    }

    public String getOperation() {
        return this.operation;
    }
}

