/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParserUtil;
import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.Directive;
import com.predic8.membrane.core.graphql.model.TypeSystemDefinition;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class ScalarTypeDefinition
implements TypeSystemDefinition {
    private String description;
    private String name;
    private List<Directive> directives;

    public ScalarTypeDefinition() {
    }

    public ScalarTypeDefinition(String description, String name, List<Directive> directives) {
        this.description = description;
        this.name = name;
        this.directives = directives;
    }

    @Override
    public void parse(Tokenizer tokenizer) throws IOException, ParsingException {
        this.name = ParserUtil.parseName(tokenizer);
        if (!tokenizer.advance()) {
            return;
        }
        this.directives = ParserUtil.parseDirectivesConstOpt(tokenizer);
        if (this.directives == null) {
            tokenizer.revert();
        }
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScalarTypeDefinition that = (ScalarTypeDefinition)o;
        return Objects.equals(this.description, that.description) && Objects.equals(this.name, that.name) && Objects.equals(this.directives, that.directives);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.name, this.directives);
    }

    public String toString() {
        return "ScalarTypeDefinition{description='" + this.description + "', name='" + this.name + "', directives=" + this.directives + "}";
    }
}

