/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParserUtil;
import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.Directive;
import com.predic8.membrane.core.graphql.model.RootOperationTypeDefinition;
import com.predic8.membrane.core.graphql.model.TypeSystemDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SchemaDefinition
implements TypeSystemDefinition {
    private String description;
    private List<Directive> directives;
    private List<RootOperationTypeDefinition> rootOperationTypeDefinitions = new ArrayList<RootOperationTypeDefinition>();

    public SchemaDefinition() {
    }

    public SchemaDefinition(String description, List<Directive> directives, List<RootOperationTypeDefinition> rootOperationTypeDefinitions) {
        this.description = description;
        this.directives = directives;
        this.rootOperationTypeDefinitions = rootOperationTypeDefinitions;
    }

    @Override
    public void parse(Tokenizer tokenizer) throws IOException, ParsingException {
        tokenizer.mustAdvance();
        this.directives = ParserUtil.parseDirectivesConstOpt(tokenizer);
        if (this.directives != null) {
            tokenizer.mustAdvance();
        }
        if (tokenizer.type() != Tokenizer.Type.PUNCTUATOR || tokenizer.integer() != 123) {
            throw new ParsingException("Expected '{'.", tokenizer.position());
        }
        this.parseRootOperationTypeDefinitions(tokenizer);
    }

    private void parseRootOperationTypeDefinitions(Tokenizer tokenizer) throws IOException, ParsingException {
        tokenizer.mustAdvance();
        do {
            if (tokenizer.type() == Tokenizer.Type.PUNCTUATOR && tokenizer.punctuator() == 125) {
                return;
            }
            RootOperationTypeDefinition rod = new RootOperationTypeDefinition();
            rod.parse(tokenizer);
            this.rootOperationTypeDefinitions.add(rod);
        } while (tokenizer.advance());
        throw new ParsingException("Expected '}'.", tokenizer.position());
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaDefinition that = (SchemaDefinition)o;
        return Objects.equals(this.description, that.description) && Objects.equals(this.directives, that.directives) && Objects.equals(this.rootOperationTypeDefinitions, that.rootOperationTypeDefinitions);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.directives, this.rootOperationTypeDefinitions);
    }

    public String toString() {
        return "SchemaDefinition{description='" + this.description + "', directives=" + this.directives + ", rootOperationTypeDefinitions=" + this.rootOperationTypeDefinitions + "}";
    }
}

