/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParserUtil;
import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.Directive;
import com.predic8.membrane.core.graphql.model.Type;
import com.predic8.membrane.core.graphql.model.Value;
import com.predic8.membrane.core.graphql.model.Variable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class VariableDefinition {
    private Variable variable;
    private Type type;
    private Value defaultValue;
    private List<Directive> directives;

    public VariableDefinition() {
    }

    public VariableDefinition(Variable variable, Type type, Value defaultValue, List<Directive> directives) {
        this.variable = variable;
        this.type = type;
        this.defaultValue = defaultValue;
        this.directives = directives;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableDefinition that = (VariableDefinition)o;
        return Objects.equals(this.variable, that.variable) && Objects.equals(this.type, that.type) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.directives, that.directives);
    }

    public int hashCode() {
        return Objects.hash(this.variable, this.type, this.defaultValue, this.directives);
    }

    public String toString() {
        return "VariableDefinition{variable='" + this.variable + "', type=" + this.type + ", defaultValue=" + this.defaultValue + ", directives=" + this.directives + "}";
    }

    public void parse(Tokenizer tokenizer) throws IOException, ParsingException {
        this.variable = new Variable();
        this.variable.parse(tokenizer);
        tokenizer.mustAdvance();
        if (tokenizer.type() != Tokenizer.Type.PUNCTUATOR || tokenizer.punctuator() != 58) {
            throw new ParsingException("Expected ':'.", tokenizer.position());
        }
        tokenizer.mustAdvance();
        this.type = ParserUtil.parseType(tokenizer);
        if (!tokenizer.advance()) {
            return;
        }
        if (tokenizer.type() == Tokenizer.Type.PUNCTUATOR && tokenizer.punctuator() == 61) {
            tokenizer.mustAdvance();
            this.defaultValue = ParserUtil.parseValueConst(tokenizer);
            if (!tokenizer.advance()) {
                return;
            }
        }
        this.directives = ParserUtil.parseDirectivesConstOpt(tokenizer);
        if (this.directives == null) {
            tokenizer.revert();
        }
    }
}

