/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http;

import com.predic8.membrane.core.http.AbstractBody;
import com.predic8.membrane.core.http.AbstractBodyTransferrer;
import com.predic8.membrane.core.http.Chunk;
import com.predic8.membrane.core.http.MessageObserver;
import com.predic8.membrane.core.util.ByteUtil;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Body
extends AbstractBody {
    private static final int BUFFER_SIZE;
    private static final int MAX_CHUNK_LENGTH;
    private static Logger log;
    private final InputStream inputStream;
    private final long length;
    private long streamedLength;

    public Body(InputStream in) throws IOException {
        this(in, -1L);
    }

    public Body(InputStream in, long length) throws IOException {
        this.inputStream = in;
        this.length = length;
    }

    public Body(byte[] content) {
        this.inputStream = null;
        this.length = content.length;
        this.chunks.clear();
        this.chunks.add(new Chunk(content));
        this.markAsRead();
    }

    @Override
    protected void readLocal() throws IOException {
        int chunkLength;
        for (long l = this.length; l > 0L || l == -1L; l -= (long)chunkLength) {
            chunkLength = l > (long)MAX_CHUNK_LENGTH ? MAX_CHUNK_LENGTH : (int)l;
            Chunk chunk = new Chunk(ByteUtil.readByteArray(this.inputStream, chunkLength));
            this.chunks.add(chunk);
            for (MessageObserver observer : this.observers) {
                observer.bodyChunk(chunk);
            }
        }
    }

    @Override
    public void discard() throws IOException {
        long skipped;
        if (this.read) {
            return;
        }
        if (this.wasStreamed()) {
            return;
        }
        for (MessageObserver observer : this.observers) {
            observer.bodyRequested(this);
        }
        byte[] buffer = null;
        boolean hasRelevantObserver = this.hasRelevantObservers();
        if (hasRelevantObserver) {
            buffer = new byte[BUFFER_SIZE];
        }
        this.chunks.clear();
        for (long toSkip = this.length; toSkip > 0L; toSkip -= skipped) {
            if (hasRelevantObserver) {
                skipped = this.inputStream.read(buffer);
                if (skipped > 0L) {
                    for (MessageObserver observer : this.observers) {
                        observer.bodyChunk(buffer, 0, (int)skipped);
                    }
                }
            } else {
                skipped = this.inputStream.skip(toSkip);
            }
            if (skipped <= 0L) break;
        }
        this.markAsRead();
    }

    @Override
    protected void writeAlreadyRead(AbstractBodyTransferrer out) throws IOException {
        if (this.getLength() > 0) {
            out.write(this.getContent(), 0, this.getLength());
        }
        out.finish(null);
    }

    @Override
    protected void writeNotRead(AbstractBodyTransferrer out) throws IOException {
        byte[] buffer = new byte[BUFFER_SIZE];
        long totalLength = 0L;
        int length = 0;
        this.chunks.clear();
        while ((this.length > totalLength || this.length == -1L) && (length = this.inputStream.read(buffer)) > 0) {
            totalLength += (long)length;
            out.write(buffer, 0, length);
            byte[] chunk = new byte[length];
            System.arraycopy(buffer, 0, chunk, 0, length);
            Chunk chunk1 = new Chunk(chunk);
            this.chunks.add(chunk1);
            for (MessageObserver observer : this.observers) {
                observer.bodyChunk(chunk1);
            }
        }
        out.finish(null);
        this.markAsRead();
    }

    @Override
    protected void writeStreamed(AbstractBodyTransferrer out) throws IOException {
        byte[] buffer = new byte[BUFFER_SIZE];
        long totalLength = 0L;
        int length = 0;
        this.chunks.clear();
        while ((this.length > totalLength || this.length == -1L) && (length = this.inputStream.read(buffer)) > 0) {
            totalLength += (long)length;
            this.streamedLength += (long)length;
            out.write(buffer, 0, length);
            for (MessageObserver observer : this.observers) {
                observer.bodyChunk(buffer, 0, length);
            }
        }
        out.finish(null);
        this.markAsRead();
    }

    @Override
    public int getLength() throws IOException {
        if (this.wasStreamed()) {
            return (int)this.streamedLength;
        }
        return super.getLength();
    }

    @Override
    protected byte[] getRawLocal() throws IOException {
        if (this.chunks.isEmpty()) {
            log.debug("size of chunks list: " + this.chunks.size() + "  " + this.hashCode());
            log.debug("chunks size is: " + this.chunks.size() + " at time: " + System.currentTimeMillis());
            return new byte[0];
        }
        return this.getContent();
    }

    static {
        String bufferSize = System.getProperty("membrane.core.http.body.buffersize");
        BUFFER_SIZE = bufferSize == null ? 8192 : Integer.parseInt(bufferSize);
        String maxChunkLength = System.getProperty("membrane.core.http.body.maxchunklength");
        MAX_CHUNK_LENGTH = maxChunkLength == null ? 1000000000 : Integer.parseInt(maxChunkLength);
        log = LoggerFactory.getLogger((String)Body.class.getName());
    }
}

