/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http;

import com.predic8.membrane.core.http.AbstractBody;
import com.predic8.membrane.core.http.Body;
import com.predic8.membrane.core.http.BodyInputStream;
import com.predic8.membrane.core.http.Chunk;
import com.predic8.membrane.core.http.MessageObserver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class BodyCollectingMessageObserver
implements MessageObserver {
    private final Strategy strategy;
    private final long limit;
    private final List<Chunk> chunks = new ArrayList<Chunk>();
    private boolean truncated = false;
    private long storedSize = 0L;

    public BodyCollectingMessageObserver(Strategy strategy, long limit) {
        this.strategy = strategy;
        this.limit = limit;
    }

    @Override
    public void bodyChunk(byte[] buffer, int offset, int length) {
        byte[] shortContent = new byte[length];
        System.arraycopy(buffer, offset, shortContent, 0, length);
        Chunk chunk = new Chunk(shortContent);
        this.bodyChunk(chunk);
    }

    @Override
    public void bodyChunk(Chunk chunk) {
        if (this.limit != -1L && this.storedSize >= this.limit) {
            if (this.strategy == Strategy.ERROR) {
                throw new RuntimeException("Body is too large for buffering.");
            }
            this.truncated = true;
            return;
        }
        this.chunks.add(chunk);
        this.storedSize += (long)chunk.getLength();
    }

    public AbstractBody getBody(AbstractBody body) throws IOException {
        if (!body.wasStreamed()) {
            return body;
        }
        return new Body(new BodyInputStream(this.chunks), this.storedSize);
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public static enum Strategy {
        ERROR,
        TRUNCATE;

    }
}

