/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.http.AbstractBody;
import com.predic8.membrane.core.http.AbstractBodyTransferrer;
import com.predic8.membrane.core.http.BodyInputStream;
import com.predic8.membrane.core.http.Chunk;
import com.predic8.membrane.core.http.ChunkedBodyTransferrer;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.MessageObserver;
import com.predic8.membrane.core.util.ByteUtil;
import com.predic8.membrane.core.util.EndOfStreamException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkedBody
extends AbstractBody {
    private static final Logger log = LoggerFactory.getLogger((String)ChunkedBody.class.getName());
    private InputStream inputStream;
    private long lengthStreamed;
    private Header trailer;
    boolean bodyObserved = false;
    boolean bodyComplete = false;

    public ChunkedBody(InputStream in) {
        log.debug("ChunkedInOutBody constructor");
        this.inputStream = in;
    }

    private static List<Chunk> readChunks(InputStream in) throws IOException {
        int chunkSize;
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        while ((chunkSize = ChunkedBody.readChunkSize(in)) > 0) {
            chunks.add(new Chunk(ByteUtil.readByteArray(in, chunkSize)));
            in.read();
            in.read();
        }
        return chunks;
    }

    private static Header readTrailer(InputStream in) throws IOException {
        in.mark(2);
        if (in.read() == 13) {
            in.read();
            return null;
        }
        in.reset();
        try {
            return new Header(in);
        }
        catch (EndOfStreamException e) {
            throw new IOException(e);
        }
    }

    private static void readChunksAndDrop(InputStream in, List<MessageObserver> observers) throws IOException {
        int chunkSize;
        while ((chunkSize = ChunkedBody.readChunkSize(in)) > 0) {
            byte[] bytes = ByteUtil.readByteArray(in, chunkSize);
            Chunk chunk = new Chunk(bytes);
            for (MessageObserver observer : observers) {
                observer.bodyChunk(chunk);
            }
            in.read();
            in.read();
        }
    }

    public static int readChunkSize(InputStream in) throws IOException {
        StringBuilder buffer = new StringBuilder();
        int c = 0;
        while ((c = in.read()) != -1) {
            if (c == 13) {
                c = in.read();
                break;
            }
            if (c == 59) {
                while ((c = in.read()) != 10) {
                }
            }
            buffer.append((char)c);
        }
        return Integer.parseInt(buffer.toString().trim(), 16);
    }

    @Override
    public void read() throws IOException {
        if (this.bodyObserved && !this.bodyComplete) {
            ByteUtil.readStream(this.getContentAsStream());
        }
        this.bodyObserved = true;
        super.read();
    }

    @Override
    public void write(AbstractBodyTransferrer out, boolean retainCopy) throws IOException {
        if (this.bodyObserved && !this.bodyComplete) {
            ByteUtil.readStream(this.getContentAsStream());
        }
        super.write(out, retainCopy);
    }

    @Override
    protected void markAsRead() {
        super.markAsRead();
        this.bodyComplete = true;
    }

    @Override
    protected void readLocal() throws IOException {
        List<Chunk> chunkList = ChunkedBody.readChunks(this.inputStream);
        this.chunks.addAll(chunkList);
        this.trailer = ChunkedBody.readTrailer(this.inputStream);
        for (Chunk chunk : chunkList) {
            for (MessageObserver observer : this.observers) {
                observer.bodyChunk(chunk);
            }
        }
    }

    @Override
    public void discard() throws IOException {
        if (this.read) {
            return;
        }
        if (this.wasStreamed()) {
            return;
        }
        for (MessageObserver observer : this.observers) {
            observer.bodyRequested(this);
        }
        ChunkedBody.readChunksAndDrop(this.inputStream, this.observers);
        this.trailer = ChunkedBody.readTrailer(this.inputStream);
        this.markAsRead();
    }

    @Override
    public InputStream getContentAsStream() throws IOException {
        this.read = true;
        if (!this.bodyObserved) {
            this.bodyObserved = true;
            for (MessageObserver observer : this.observers) {
                observer.bodyRequested(this);
            }
            this.chunks.clear();
        }
        return new BodyInputStream(this.chunks){

            @Override
            protected Chunk readNextChunk() throws IOException {
                if (ChunkedBody.this.bodyComplete) {
                    return null;
                }
                int chunkSize = ChunkedBody.readChunkSize(ChunkedBody.this.inputStream);
                if (chunkSize > 0) {
                    Chunk c = new Chunk(ByteUtil.readByteArray(ChunkedBody.this.inputStream, chunkSize));
                    ChunkedBody.this.inputStream.read();
                    ChunkedBody.this.inputStream.read();
                    for (MessageObserver observer : ChunkedBody.this.observers) {
                        observer.bodyChunk(c);
                    }
                    return c;
                }
                ChunkedBody.this.trailer = ChunkedBody.readTrailer(ChunkedBody.this.inputStream);
                ChunkedBody.this.bodyComplete = true;
                for (MessageObserver observer : ChunkedBody.this.observers) {
                    observer.bodyComplete(ChunkedBody.this);
                }
                ChunkedBody.this.observers.clear();
                return null;
            }
        };
    }

    @Override
    protected void writeNotRead(AbstractBodyTransferrer out) throws IOException {
        int chunkSize;
        log.debug("writeNotReadChunked");
        while ((chunkSize = ChunkedBody.readChunkSize(this.inputStream)) > 0) {
            Chunk chunk = new Chunk(ByteUtil.readByteArray(this.inputStream, chunkSize));
            out.write(chunk);
            this.chunks.add(chunk);
            for (MessageObserver observer : this.observers) {
                observer.bodyChunk(chunk);
            }
            this.inputStream.read();
            this.inputStream.read();
        }
        this.trailer = ChunkedBody.readTrailer(this.inputStream);
        out.finish(this.trailer);
        this.markAsRead();
    }

    @Override
    protected void writeStreamed(AbstractBodyTransferrer out) throws IOException {
        int chunkSize;
        log.debug("writeStreamed");
        while ((chunkSize = ChunkedBody.readChunkSize(this.inputStream)) > 0) {
            Chunk chunk = new Chunk(ByteUtil.readByteArray(this.inputStream, chunkSize));
            out.write(chunk);
            for (MessageObserver observer : this.observers) {
                observer.bodyChunk(chunk);
            }
            this.inputStream.read();
            this.inputStream.read();
            this.lengthStreamed += (long)chunkSize;
        }
        this.trailer = ChunkedBody.readTrailer(this.inputStream);
        out.finish(this.trailer);
        this.markAsRead();
    }

    protected int getRawLength() throws IOException {
        if (this.chunks.isEmpty()) {
            return 0;
        }
        int length = this.getLength();
        for (Chunk chunk : this.chunks) {
            length += Long.toHexString(chunk.getLength()).getBytes(Constants.UTF_8_CHARSET).length;
            length += 2 * Constants.CRLF_BYTES.length;
        }
        length += "0".getBytes(Constants.UTF_8_CHARSET).length;
        return length += 2 * Constants.CRLF_BYTES.length;
    }

    @Override
    protected byte[] getRawLocal() throws IOException {
        byte[] raw = new byte[this.getRawLength()];
        int destPos = 0;
        for (Chunk chunk : this.chunks) {
            destPos = chunk.copyChunkLength(raw, destPos, this);
            destPos = this.copyCRLF(raw, destPos);
            destPos = chunk.copyChunk(raw, destPos);
            destPos = this.copyCRLF(raw, destPos);
        }
        destPos = this.copyLastChunk(raw, destPos);
        destPos = this.copyCRLF(raw, destPos);
        return raw;
    }

    private int copyLastChunk(byte[] raw, int destPos) {
        System.arraycopy(ChunkedBodyTransferrer.ZERO, 0, raw, destPos, ChunkedBodyTransferrer.ZERO.length);
        destPos += ChunkedBodyTransferrer.ZERO.length;
        destPos = this.copyCRLF(raw, destPos);
        return destPos;
    }

    private int copyCRLF(byte[] raw, int destPos) {
        System.arraycopy(Constants.CRLF_BYTES, 0, raw, destPos, 2);
        return destPos += 2;
    }

    @Override
    protected void writeAlreadyRead(AbstractBodyTransferrer out) throws IOException {
        if (this.getLength() > 0) {
            for (Chunk chunk : this.chunks) {
                out.write(chunk);
            }
        }
        out.finish(this.trailer);
    }

    @Override
    public int getLength() throws IOException {
        if (this.wasStreamed()) {
            return (int)this.lengthStreamed;
        }
        return super.getLength();
    }

    @Override
    public boolean isRead() {
        return super.isRead() && this.bodyComplete;
    }

    @Override
    public boolean hasTrailer() {
        return this.trailer != null;
    }

    @Override
    public Header getTrailer() {
        return this.trailer;
    }

    @Override
    public boolean setTrailer(Header trailer) {
        this.trailer = trailer;
        return true;
    }
}

