/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.http.HeaderName;
import com.predic8.membrane.core.http.cookie.Cookies;
import com.predic8.membrane.core.http.cookie.MimeHeaders;
import com.predic8.membrane.core.http.cookie.ServerCookie;
import com.predic8.membrane.core.util.EndOfStreamException;
import com.predic8.membrane.core.util.HttpUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;

public class Header {
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONNECTION = "Connection";
    public static final String PROXY_CONNECTION = "Proxy-Connection";
    public static final String HOST = "Host";
    public static final String EXPECT = "Expect";
    public static final String X_FORWARDED_FOR = "X-Forwarded-For";
    public static final String X_FORWARDED_PROTO = "X-Forwarded-Proto";
    public static final String X_FORWARDED_HOST = "X-Forwarded-Host";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String SOAP_ACTION = "SOAPAction";
    public static final String ACCEPT = "Accept";
    public static final String LOCATION = "Location";
    public static final String AUTHORIZATION = "Authorization";
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String COOKIE = "Cookie";
    public static final String DESTINATION = "Destination";
    public static final String VALIDATION_ERROR_SOURCE = "X-Validation-Error-Source";
    public static final String USER_AGENT = "User-Agent";
    public static final String X_REQUESTED_WITH = "X-Requested-With";
    public static final String EXPIRES = "Expires";
    public static final String KEEP_ALIVE = "Keep-Alive";
    public static final String SERVER = "Server";
    public static final String PRAGMA = "Pragma";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String UPGRADE = "Upgrade";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ORIGIN = "Origin";
    public static final String X_HTTP_METHOD_OVERRIDE = "X-HTTP-Method-Override";
    public static final String CHUNKED = "chunked";
    public static final String TIMEOUT = "timeout";
    public static final String MAX = "max";
    public static final String CLOSE = "close";
    private static final Pattern mediaTypePattern = Pattern.compile("(.+)/([^;]+)(;.*)?");
    private static final Pattern parameterPattern = Pattern.compile("(.+)=\"?([^\"]+)\"?");
    private static final Pattern timeoutPattern = Pattern.compile("timeout\\s*=\\s*(\\d+)", 2);
    private static final Pattern maxPattern = Pattern.compile("max\\s*=\\s*(\\d+)", 2);
    private static final Logger log = LoggerFactory.getLogger((String)Header.class.getName());
    private final ArrayList<HeaderField> fields = new ArrayList();

    public Header() {
    }

    public Header(InputStream in) throws IOException, EndOfStreamException {
        String line;
        while ((line = HttpUtil.readLine(in)).length() > 0) {
            try {
                this.add(new HeaderField(line));
            }
            catch (StringIndexOutOfBoundsException sie) {
                log.error("Header read line that caused problems: " + line);
            }
        }
    }

    public Header(String header) throws IOException, EndOfStreamException {
        for (String line : header.split("\r?\n")) {
            if (line.length() <= 0) continue;
            this.add(new HeaderField(line));
        }
    }

    public Header(Header header) {
        for (HeaderField field : header.fields) {
            this.fields.add(new HeaderField(field));
        }
    }

    public void add(String key, String val) {
        this.fields.add(new HeaderField(key, val));
    }

    public void add(HeaderField field) {
        this.fields.add(field);
    }

    public void remove(HeaderField field) {
        this.fields.remove(field);
    }

    public void removeFields(String name) {
        ArrayList<HeaderField> deleteValues = new ArrayList<HeaderField>();
        for (HeaderField field : this.fields) {
            if (!field.getHeaderName().equals(name)) continue;
            deleteValues.add(field);
        }
        this.fields.removeAll(deleteValues);
    }

    public List<HeaderField> getValues(HeaderName headerName) {
        ArrayList<HeaderField> res = new ArrayList<HeaderField>();
        for (HeaderField headerField : this.fields) {
            if (!headerField.getHeaderName().equals(headerName)) continue;
            res.add(headerField);
        }
        return res;
    }

    public String getFirstValue(String name) {
        for (HeaderField field : this.fields) {
            if (!field.getHeaderName().equals(name)) continue;
            return field.getValue();
        }
        return null;
    }

    public HeaderField[] getAllHeaderFields() {
        return this.fields.toArray(new HeaderField[this.fields.size()]);
    }

    public void write(OutputStream out) throws IOException {
        StringBuilder buffer = new StringBuilder();
        for (HeaderField field : this.fields) {
            String name = field.getHeaderName().toString();
            String value = field.getValue();
            buffer.append(name).append(": ").append(value).append("\r\n");
        }
        out.write(buffer.toString().getBytes(Constants.ISO_8859_1_CHARSET));
    }

    public void setValue(String name, String value) {
        boolean found = false;
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!this.fields.get(i).getHeaderName().equals(name)) continue;
            if (found) {
                this.fields.set(i, this.fields.get(this.fields.size() - 1));
                this.fields.remove(this.fields.size() - 1);
                --i;
                continue;
            }
            this.fields.get(i).setValue(value);
            found = true;
        }
        if (found) {
            return;
        }
        this.fields.add(new HeaderField(name, value));
    }

    public void setHost(String value) {
        this.setValue(HOST, value);
    }

    public void setContentLength(long length) {
        this.setValue(CONTENT_LENGTH, "" + length);
    }

    public void setProxyAutorization(String value) {
        this.setValue(PROXY_AUTHORIZATION, value);
    }

    public boolean isChunked() {
        return CHUNKED.equals(this.getFirstValue(TRANSFER_ENCODING));
    }

    public long getContentLength() {
        if (!this.hasContentLength()) {
            return -1L;
        }
        return Long.parseLong(this.getFirstValue(CONTENT_LENGTH));
    }

    public String getContentType() {
        return this.getFirstValue(CONTENT_TYPE);
    }

    public ContentType getContentTypeObject() throws ParseException {
        String contentType = this.getContentType();
        return contentType == null ? null : new ContentType(contentType);
    }

    public void setContentType(String value) {
        this.setValue(CONTENT_TYPE, value);
    }

    public String getSOAPAction() {
        return this.getFirstValue(SOAP_ACTION);
    }

    public void setSOAPAction(String value) {
        this.setValue(SOAP_ACTION, value);
    }

    public String getAccept() {
        return this.getFirstValue(ACCEPT);
    }

    public void setAccept(String value) {
        this.add(ACCEPT, value);
    }

    public String getConnection() {
        return this.getFirstValue(CONNECTION);
    }

    public void setConnection(String connection) {
        this.setValue(CONNECTION, connection);
    }

    public String getProxyConnection() {
        return this.getFirstValue(PROXY_CONNECTION);
    }

    public void setProxyConnection(String connection) {
        this.add(PROXY_CONNECTION, connection);
    }

    public boolean isProxyConnectionClose() {
        if (this.getProxyConnection() == null) {
            return false;
        }
        return CLOSE.equalsIgnoreCase(this.getProxyConnection());
    }

    public boolean isConnectionClose() {
        if (this.getConnection() == null) {
            return false;
        }
        return CLOSE.equalsIgnoreCase(this.getConnection());
    }

    public boolean hasContentLength() {
        return this.getFirstValue(CONTENT_LENGTH) != null;
    }

    public String getHost() {
        return this.getFirstValue(HOST);
    }

    public boolean is100ContinueExpected() {
        return "100-continue".equalsIgnoreCase(this.getFirstValue(EXPECT));
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (HeaderField field : this.fields) {
            res.append(field.toString());
        }
        return res.toString();
    }

    public void setAuthorization(String user, String password) throws UnsupportedEncodingException {
        String value = "Basic " + new String(Base64.encodeBase64((byte[])(user + ":" + password).getBytes("UTF-8")), "UTF-8");
        this.setValue(AUTHORIZATION, value);
    }

    public void setXForwardedFor(String value) {
        this.setValue(X_FORWARDED_FOR, value);
    }

    public String getXForwardedFor() {
        return this.getFirstValue(X_FORWARDED_FOR);
    }

    public void setXForwardedProto(String value) {
        this.setValue(X_FORWARDED_PROTO, value);
    }

    public String getXForwardedProto() {
        return this.getFirstValue(X_FORWARDED_PROTO);
    }

    public String getContentEncoding() {
        return this.getFirstValue(CONTENT_ENCODING);
    }

    public String getUserAgent() {
        return this.getFirstValue(USER_AGENT);
    }

    public String getCharset() {
        if (this.getContentType() == null) {
            return "UTF-8";
        }
        String charset = this.getMediaTypeParameters().get("charset");
        if (charset == null) {
            return "UTF-8";
        }
        return charset;
    }

    private Map<String, String> getMediaTypeParameters() {
        Matcher m = mediaTypePattern.matcher(this.getContentType());
        m.matches();
        boolean logDebug = log.isDebugEnabled();
        if (logDebug) {
            log.debug("type: " + m.group(1));
            log.debug("subtype: " + m.group(2));
            log.debug("parameters: " + m.group(3));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (m.group(3) == null) {
            return map;
        }
        for (String param : m.group(3).substring(1).split("\\s*;\\s*")) {
            Matcher paramMat;
            if (logDebug) {
                log.debug("parsing parameter: " + param);
            }
            if ((paramMat = parameterPattern.matcher(param)).matches()) {
                if (logDebug) {
                    log.debug("parameter: " + paramMat.group(1) + "=" + paramMat.group(2));
                }
                map.put(paramMat.group(1).trim(), paramMat.group(2));
                continue;
            }
            if (!logDebug) continue;
            log.debug("parameter did not match " + parameterPattern.toString());
        }
        return map;
    }

    public void addCookieSession(String cookieName, String value) {
        this.addRawCookieSession(cookieName + "=" + value);
    }

    public void addRawCookieSession(String cookie) {
        this.add(SET_COOKIE, cookie);
    }

    public String getFirstCookie(String cookieName) {
        Cookies c = new Cookies(new MimeHeaders(this));
        for (int i = 0; i < c.getCookieCount(); ++i) {
            ServerCookie sc = c.getCookie(i);
            if (!sc.getName().equals(cookieName)) continue;
            return sc.getValue().toString();
        }
        return null;
    }

    public int estimateHeapSize() {
        int size = 10;
        for (HeaderField hf : this.fields) {
            size += 4 + hf.estimateHeapSize();
        }
        return size;
    }

    public int getBestAcceptedType(MediaType[] supported) {
        List m;
        String accept = this.getFirstValue(ACCEPT);
        if (accept == null) {
            return -1;
        }
        try {
            m = MediaType.parseMediaTypes((String)accept);
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
        MediaType.sortByQualityValue((List)m);
        for (MediaType t : m) {
            for (int i = 0; i < supported.length; ++i) {
                if (!t.includes(supported[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static MediaType[] convertStringsToMediaType(String[] mediaTypes) {
        MediaType[] m = new MediaType[mediaTypes.length];
        for (int i = 0; i < mediaTypes.length; ++i) {
            m[i] = MediaType.parseMediaType((String)mediaTypes[i]);
        }
        return m;
    }

    public int getNumberOf(String headerName) {
        int res = 0;
        for (HeaderField headerField : this.fields) {
            if (!headerField.getHeaderName().equals(headerName)) continue;
            ++res;
        }
        return res;
    }

    public static long parseKeepAliveHeader(String keepAliveHeaderValue, String paramName) {
        Pattern p;
        if (paramName == TIMEOUT) {
            p = timeoutPattern;
        } else if (paramName == MAX) {
            p = maxPattern;
        } else {
            throw new InvalidParameterException("paramName must be one of Header.TIMEOUT and .MAX .");
        }
        Matcher m = p.matcher(keepAliveHeaderValue);
        if (!m.find()) {
            return -1L;
        }
        return Long.parseLong(m.group(1));
    }

    public void clear() {
        this.fields.clear();
    }

    public boolean isUserAgentSupportsSNI() {
        String ua = this.getUserAgent();
        if (ua == null) {
            return false;
        }
        if (this.getBrowserVersion(ua, "Firefox") >= 2) {
            return true;
        }
        if (this.getBrowserVersion(ua, "Opera") >= 8) {
            return true;
        }
        if (this.getBrowserVersion(ua, "Safari") >= 522) {
            return this.getBrowserVersion(ua, "Windows NT") >= 6 || this.getBrowserVersion(ua, "Mac OS X 10") >= 6;
        }
        if (this.getBrowserVersion(ua, "MSIE") >= 7 || this.getBrowserVersion(ua, "Trident") >= 5) {
            return this.getBrowserVersion(ua, "Windows NT") >= 6;
        }
        if (this.getBrowserVersion(ua, "Chrome") > 0) {
            int windows = this.getBrowserVersion(ua, "Windows NT");
            return windows >= 6 || windows == -1;
        }
        return false;
    }

    private int getBrowserVersion(String userAgent, String browserID) {
        char c;
        int p = userAgent.indexOf(browserID);
        if (userAgent.length() == (p += browserID.length())) {
            return -1;
        }
        if ((c = userAgent.charAt(p++)) != ' ' && c != '/' && c != '_') {
            return -1;
        }
        int version = 0;
        while (userAgent.length() != p && (c = userAgent.charAt(p++)) >= '0' && c <= '9') {
            version = version * 10 + (c - 48);
        }
        return version;
    }

    public void setNoCacheResponseHeaders() {
        this.setValue(EXPIRES, "Tue, 03 Jul 2001 06:00:00 GMT");
        this.setValue(CACHE_CONTROL, "no-store, no-cache, must-revalidate, max-age=0");
        this.add(CACHE_CONTROL, "post-check=0, pre-check=0");
        this.add(PRAGMA, "no-cache");
    }

    public String getAuthorization() {
        return this.getFirstValue(AUTHORIZATION);
    }

    public void setWwwAuthenticate(String params) {
        this.setValue(WWW_AUTHENTICATE, params);
    }

    public String getWwwAuthenticate() {
        return this.getFirstValue(WWW_AUTHENTICATE);
    }

    public String getNormalizedValue(String headerName) {
        StringBuilder sb = new StringBuilder();
        for (HeaderField headerField : this.fields) {
            if (!headerField.getHeaderName().equals(headerName)) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(headerField.getValue());
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    public boolean isBinaryContentType() {
        String contentType = this.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.startsWith("audio/") || contentType.startsWith("image/") || contentType.startsWith("video/") || contentType.startsWith("application/octet-stream");
    }

    public String getXForwardedHost() {
        return this.getFirstValue(X_FORWARDED_HOST);
    }

    public void setXForwardedHost(String xForwardedHostHeaderValue) {
        this.setValue(X_FORWARDED_HOST, xForwardedHostHeaderValue);
    }
}

