/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http;

import com.predic8.membrane.core.http.HeaderName;

public class HeaderField {
    private HeaderName headerName;
    private String value;

    public HeaderField(HeaderName headerName, String value) {
        this.headerName = headerName;
        this.value = value;
    }

    public HeaderField(String line) {
        this.headerName = new HeaderName(this.getName(line));
        this.value = this.getValue(line);
    }

    private String getValue(String line) {
        return line.substring(line.indexOf(":") + 1).trim();
    }

    private String getName(String line) {
        return line.substring(0, line.indexOf(":"));
    }

    public HeaderField(String headerName, String value) {
        this(new HeaderName(headerName), value);
    }

    public HeaderField(HeaderField element) {
        this.headerName = new HeaderName(element.headerName);
        this.value = element.value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public HeaderName getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(HeaderName headerName) {
        this.headerName = headerName;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.headerName.toString());
        buf.append(": ");
        buf.append(this.value);
        buf.append("\r\n");
        return buf.toString();
    }

    public int estimateHeapSize() {
        return 2 * (4 + this.headerName.toString().length() + (this.value == null ? 0 : this.value.length()));
    }
}

