/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http;

import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.ParseException;

public class MimeType {
    public static final String APPLICATION = "application";
    public static final String APPLICATION_SOAP = "application/soap+xml";
    public static final String APPLICATION_XML = "application/xml";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_XML_UTF8 = "text/xml;charset=UTF-8";
    public static final String TEXT_HTML_UTF8 = "text/html;charset=UTF-8";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_PLAIN_UTF8 = "text/plain;charset=UTF-8";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_JSON_UTF8 = "application/json;charset=utf-8";
    public static final String APPLICATION_JOSE_JSON = "application/jose+json";
    public static final String APPLICATION_X_YAML = "application/x-yaml";
    public static final String APPLICATION_PROBLEM_JSON = "application/problem+json";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_APPLY_PATCH_YAML = "application/apply-patch+yaml";
    public static final String APPLICATION_GRAPHQL = "application/graphql";
    public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final ContentType APPLICATION_JSON_CONTENT_TYPE = new ContentType("application", "json", null);
    public static final ContentType APPLICATION_X_WWW_FORM_URLENCODED_CONTENT_TYPE = new ContentType("application", "application/x-www-form-urlencoded", null);

    public static boolean isXML(String mediaType) {
        try {
            ContentType contentType = new ContentType(mediaType);
            if (contentType.getSubType().contains("xml")) {
                return true;
            }
            if (contentType.getSubType().equals("xhtml")) {
                return true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isWWWFormUrlEncoded(String mediaType) {
        try {
            return new ContentType(mediaType).match(APPLICATION_X_WWW_FORM_URLENCODED);
        }
        catch (ParseException parseException) {
            return false;
        }
    }
}

