/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http.xml;

import com.predic8.membrane.core.http.xml.Headers;
import com.predic8.membrane.core.http.xml.Message;
import com.predic8.membrane.core.http.xml.URI;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class Request
extends Message {
    public static final String ELEMENT_NAME = "request";
    private String method;
    private String httpVersion;
    private URI uri;

    public Request(com.predic8.membrane.core.http.Request req) throws Exception {
        super(req);
        this.setMethod(req.getMethod());
        this.setHttpVersion(req.getVersion());
        this.setUri(new URI(req.getUri()));
    }

    public Request() {
    }

    @Override
    protected void parseAttributes(XMLStreamReader token) throws XMLStreamException {
        this.method = token.getAttributeValue("", "method");
        this.httpVersion = token.getAttributeValue("", "http-version");
    }

    @Override
    protected void parseChildren(XMLStreamReader token, String child) throws Exception {
        if ("uri".equals(child)) {
            this.uri = (URI)new URI().parse(token);
        } else if ("headers".equals(child)) {
            this.headers = (Headers)new Headers().parse(token);
        }
    }

    @Override
    public void write(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("http", ELEMENT_NAME, "http://membrane-soa.org/schemas/http/v1/");
        out.writeNamespace("http", "http://membrane-soa.org/schemas/http/v1/");
        out.writeAttribute("method", this.method);
        out.writeAttribute("http-version", this.httpVersion);
        this.uri.write(out);
        this.writeIfNotNull(this.headers, out);
        if (this.body != null) {
            out.writeStartElement("body");
            this.body.write(out);
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    protected String getElementName() {
        return ELEMENT_NAME;
    }
}

