/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.session.JwtSessionManager;
import com.predic8.membrane.core.interceptor.session.SessionManager;

public abstract class AbstractInterceptorWithSession
extends AbstractInterceptor {
    SessionManager sessionManager;

    @Override
    public void init() throws Exception {
        if (this.sessionManager == null) {
            this.sessionManager = new JwtSessionManager();
        }
        this.sessionManager.init(this.router);
    }

    protected abstract Outcome handleRequestInternal(Exchange var1) throws Exception;

    protected abstract Outcome handleResponseInternal(Exchange var1) throws Exception;

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        Outcome outcome = this.handleRequestInternal(exc);
        this.sessionManager.postProcess(exc);
        return outcome;
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        Outcome outcome = this.handleResponseInternal(exc);
        this.sessionManager.postProcess(exc);
        return outcome;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @MCChildElement(order=0)
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }
}

