/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.rules.AbstractProxy;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.transport.ssl.AcmeSSLContext;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.acme.AcmeClient;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="acmeHttpChallenge")
public class AcmeHttpChallengeInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(AcmeHttpChallengeInterceptor.class);
    public static final String PREFIX = "/.well-known/acme-challenge/";
    private boolean ignorePort;

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        if (exc.getRequest().getUri().startsWith(PREFIX)) {
            String token = exc.getRequest().getUri().substring(PREFIX.length());
            String host = this.ignorePort ? exc.getRequest().getHeader().getHost().replaceAll(":.*", "") : exc.getRequest().getHeader().getHost();
            for (Rule rule : this.router.getRules()) {
                AcmeClient acmeClient;
                String correctToken;
                AcmeSSLContext acmeSSLContext;
                SSLContext sslInboundContext;
                if (!(rule instanceof AbstractProxy) || !((sslInboundContext = ((AbstractProxy)rule).getSslInboundContext()) instanceof AcmeSSLContext) || Arrays.stream((acmeSSLContext = (AcmeSSLContext)sslInboundContext).getHosts()).noneMatch(h -> h.equals(host)) || (correctToken = (acmeClient = acmeSSLContext.getClient()).getToken(host)) == null || !correctToken.equals(token)) continue;
                String keyAuth = token + "." + acmeClient.getThumbprint();
                exc.setResponse(Response.ok().header("Content-Type", "application/octet-stream").body(keyAuth).build());
                return Outcome.RETURN;
            }
            LOG.warn("Returning 404 in response to ACME challenge token " + token);
            exc.setResponse(Response.notFound().build());
            return Outcome.RETURN;
        }
        return super.handleRequest(exc);
    }

    public boolean isIgnorePort() {
        return this.ignorePort;
    }

    public void setIgnorePort(boolean ignorePort) {
        this.ignorePort = ignorePort;
    }
}

