/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.openapi.util.UriUtil;
import com.predic8.membrane.core.rules.AbstractServiceProxy;
import com.predic8.membrane.core.rules.InternalProxy;
import com.predic8.membrane.core.util.URIFactory;
import com.predic8.membrane.core.util.URLUtil;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="dispatching")
public class DispatchingInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)DispatchingInterceptor.class.getName());

    public DispatchingInterceptor() {
        this.name = "Dispatching Interceptor";
        this.setFlow(Interceptor.Flow.Set.REQUEST);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        if (exc.getRule() instanceof AbstractServiceProxy) {
            exc.getDestinations().add(DispatchingInterceptor.getForwardingDestination(this.router.getUriFactory(), exc));
            this.setSNIPropertyOnExchange(exc);
            return Outcome.CONTINUE;
        }
        exc.getDestinations().add(exc.getRequest().getUri());
        return Outcome.CONTINUE;
    }

    private void setSNIPropertyOnExchange(Exchange exc) {
        String sni;
        AbstractServiceProxy asp = (AbstractServiceProxy)exc.getRule();
        if (asp.getTargetSSL() != null && (sni = asp.getTargetSSL().getServerName()) != null) {
            exc.setProperty("SNI_SERVER_NAME", sni);
        }
    }

    public static String getForwardingDestination(URIFactory uriFactory, Exchange exc) throws Exception {
        String urlResult = null;
        if (exc.getRule() instanceof InternalProxy) {
            urlResult = DispatchingInterceptor.handleInternalProxy(exc);
        }
        if (exc.getRule() instanceof AbstractServiceProxy) {
            urlResult = DispatchingInterceptor.handleAbstractServiceProxy(uriFactory, exc);
        }
        log.debug("destination: " + urlResult);
        return urlResult != null ? urlResult : exc.getRequest().getUri();
    }

    private static String handleInternalProxy(Exchange exc) throws MalformedURLException {
        InternalProxy ip = (InternalProxy)exc.getRule();
        if (ip.getTarget() == null) {
            return null;
        }
        if (ip.getTarget().getUrl() != null) {
            return ip.getTarget().getUrl();
        }
        if (ip.getTarget().getHost() != null) {
            return new URL(ip.getTarget().getSslParser() != null ? "https" : "http", ip.getTarget().getHost(), ip.getTarget().getPort(), exc.getRequest().getUri()).toString();
        }
        return null;
    }

    protected static String handleAbstractServiceProxy(URIFactory uriFactory, Exchange exc) throws MalformedURLException, URISyntaxException {
        AbstractServiceProxy p = (AbstractServiceProxy)exc.getRule();
        if (p.getTargetURL() != null) {
            if (p.getTargetURL().startsWith("service:") && !p.getTargetURL().contains("/")) {
                return "service://" + URLUtil.getHost(p.getTargetURL()) + exc.getRequest().getUri();
            }
            if (p.getTargetURL().startsWith("http") && !UriUtil.getPathFromURL(uriFactory, p.getTargetURL()).contains("/")) {
                return p.getTargetURL() + exc.getRequestURI();
            }
            return p.getTargetURL();
        }
        if (p.getTargetHost() != null) {
            return new URL(p.getTargetScheme(), p.getTargetHost(), p.getTargetPort(), exc.getRequest().getUri()).toString();
        }
        return null;
    }
}

