/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import com.predic8.membrane.core.util.ErrorUtil;
import com.predic8.membrane.core.util.URLUtil;
import java.net.ConnectException;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="httpClient")
public class HTTPClientInterceptor
extends AbstractInterceptor {
    private static Logger log = LoggerFactory.getLogger((String)HTTPClientInterceptor.class.getName());
    private boolean failOverOn5XX;
    private boolean adjustHostHeader = true;
    private HttpClientConfiguration httpClientConfig;
    private HttpClient hc;

    public HTTPClientInterceptor() {
        this.name = "HTTPClient";
        this.setFlow(Interceptor.Flow.Set.REQUEST);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        exc.blockRequestIfNeeded();
        try {
            this.hc.call(exc, this.adjustHostHeader, this.failOverOn5XX);
            return Outcome.RETURN;
        }
        catch (ConnectException e) {
            String msg = String.format("Target %s is not reachable.", this.getDestination(exc));
            log.warn(msg);
            log.warn("Maybe the target is only reachable over an HTTP proxy server. Please check proxy settings in conf/proxies.xml.");
            ErrorUtil.createAndSetErrorResponse(exc, 502, msg);
            return Outcome.ABORT;
        }
        catch (UnknownHostException e) {
            String msg = String.format("Target host %s is unknown. DNS was unable to resolve host name.", URLUtil.getHost(this.getDestination(exc)));
            log.warn(msg);
            log.warn("Maybe the target is only reachable over an HTTP proxy server. Please check proxy settings in conf/proxies.xml.");
            ErrorUtil.createAndSetErrorResponse(exc, 500, msg);
            return Outcome.ABORT;
        }
    }

    private String getDestination(Exchange exc) {
        return exc.getDestinations().get(0);
    }

    @Override
    public void init(Router router) throws Exception {
        super.init(router);
        this.hc = router.getHttpClientFactory().createClient(this.httpClientConfig);
        this.hc.setStreamPumpStats(this.getRouter().getStatistics().getStreamPumpStats());
    }

    public boolean isFailOverOn5XX() {
        return this.failOverOn5XX;
    }

    @MCAttribute
    public void setFailOverOn5XX(boolean failOverOn5XX) {
        this.failOverOn5XX = failOverOn5XX;
    }

    public boolean isAdjustHostHeader() {
        return this.adjustHostHeader;
    }

    @MCAttribute
    public void setAdjustHostHeader(boolean adjustHostHeader) {
        this.adjustHostHeader = adjustHostHeader;
    }

    public HttpClientConfiguration getHttpClientConfig() {
        return this.httpClientConfig;
    }

    @MCChildElement
    public void setHttpClientConfig(HttpClientConfiguration httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
    }
}

