/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.MCTextContent;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="headerFilter")
public class HeaderFilterInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(HeaderFilterInterceptor.class);
    private List<Rule> rules = new ArrayList<Rule>();

    public HeaderFilterInterceptor() {
        this.name = "Header Filter";
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        this.handleMessage(exc.getRequest());
        return Outcome.CONTINUE;
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        this.handleMessage(exc.getResponse());
        return Outcome.CONTINUE;
    }

    @Override
    public void handleAbort(Exchange exchange) {
        this.handleMessage(exchange.getResponse());
    }

    private void handleMessage(Message msg) {
        if (msg == null) {
            return;
        }
        Header h = msg.getHeader();
        if (h == null) {
            return;
        }
        block3: for (HeaderField hf : h.getAllHeaderFields()) {
            for (Rule r : this.rules) {
                if (!r.matches(hf.getHeaderName().toString())) continue;
                switch (r.getAction()) {
                    case REMOVE: {
                        log.debug("Removing HTTP header " + hf.getHeaderName().toString());
                        h.remove(hf);
                        break;
                    }
                }
                continue block3;
            }
        }
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    @MCChildElement
    @Required
    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public static class Rule {
        private final Action action;
        private String pattern;
        private Pattern p;

        public Rule(Action action) {
            this.action = action;
        }

        public Rule(String pattern, Action action) {
            this(action);
            this.setPattern(pattern);
        }

        public String getPattern() {
            return this.pattern;
        }

        @MCTextContent
        public void setPattern(String pattern) {
            this.pattern = pattern;
            this.p = Pattern.compile(pattern);
        }

        public boolean matches(String header) {
            return this.p.matcher(header).matches();
        }

        public Action getAction() {
            return this.action;
        }
    }

    public static enum Action {
        KEEP,
        REMOVE;

    }

    @MCElement(name="exclude", mixed=true)
    public static class Exclude
    extends Rule {
        public Exclude() {
            super(Action.REMOVE);
        }
    }

    @MCElement(name="include", mixed=true)
    public static class Include
    extends Rule {
        public Include() {
            super(Action.KEEP);
        }
    }
}

