/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.transport.http.AbortException;
import java.util.EnumSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptorFlowController {
    private static final Logger log = LoggerFactory.getLogger(InterceptorFlowController.class);
    public static final String ABORTION_REASON = "abortionReason";

    public void invokeHandlers(Exchange exchange, List<Interceptor> interceptors) throws Exception {
        try {
            switch (this.invokeRequestHandlers(exchange, interceptors)) {
                case CONTINUE: {
                    throw new Exception("The last interceptor in the main chain may not return CONTINUE. Change it to RETURN.");
                }
                case RETURN: {
                    break;
                }
                case ABORT: {
                    throw new AbortException();
                }
            }
            this.invokeResponseHandlers(exchange);
        }
        catch (Exception e) {
            exchange.setProperty(ABORTION_REASON, e);
            this.invokeAbortionHandlers(exchange);
            throw e;
        }
    }

    public Outcome invokeRequestHandlers(Exchange exchange, List<Interceptor> interceptors) throws Exception {
        boolean logDebug = log.isDebugEnabled();
        for (Interceptor i : interceptors) {
            Outcome o;
            EnumSet<Interceptor.Flow> f = i.getFlow();
            if (f.contains((Object)Interceptor.Flow.RESPONSE) && !f.contains((Object)Interceptor.Flow.REQUEST)) {
                exchange.pushInterceptorToStack(i);
                continue;
            }
            if (logDebug) {
                log.debug("Invoking request handler: " + i.getDisplayName() + " on exchange: " + exchange);
            }
            if ((o = i.handleRequest(exchange)) != Outcome.CONTINUE) {
                return o;
            }
            if (!f.contains((Object)Interceptor.Flow.RESPONSE)) continue;
            exchange.pushInterceptorToStack(i);
        }
        return Outcome.CONTINUE;
    }

    public void invokeResponseHandlers(Exchange exchange) throws Exception {
        Interceptor i;
        boolean logDebug = log.isDebugEnabled();
        while ((i = exchange.popInterceptorFromStack()) != null) {
            if (logDebug) {
                log.debug("Invoking response handler: " + i.getDisplayName() + " on exchange: " + exchange);
            }
            if (i.handleResponse(exchange) != Outcome.ABORT) continue;
            throw new AbortException();
        }
    }

    private void invokeAbortionHandlers(Exchange exchange) {
        Interceptor i;
        boolean logDebug = log.isDebugEnabled();
        while ((i = exchange.popInterceptorFromStack()) != null) {
            try {
                if (logDebug) {
                    log.debug("Invoking abortion handler: " + i.getDisplayName() + " on exchange: " + exchange);
                }
                i.handleAbort(exchange);
            }
            catch (Exception e) {
                log.warn(i.getDisplayName() + " handleAbort() threw an exception (ignoring it):", (Throwable)e);
            }
        }
    }
}

