/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import org.slf4j.LoggerFactory;

@MCElement(name="log")
public class LogInterceptor
extends AbstractInterceptor {
    private boolean headerOnly = true;
    private String category = LogInterceptor.class.getName();
    private Level level = Level.INFO;

    public LogInterceptor() {
        this.name = "Log";
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        this.log("==== Request ===");
        this.logMessage(exc.getRequest());
        return Outcome.CONTINUE;
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        this.log("==== Response ===");
        this.logMessage(exc.getResponse());
        return Outcome.CONTINUE;
    }

    public boolean isHeaderOnly() {
        return this.headerOnly;
    }

    @MCAttribute
    public void setHeaderOnly(boolean headerOnly) {
        this.headerOnly = headerOnly;
    }

    public Level getLevel() {
        return this.level;
    }

    @MCAttribute
    public void setLevel(Level level) {
        this.level = level;
    }

    private void logMessage(Message msg) throws Exception {
        if (msg == null) {
            this.log("no message");
            this.log("================");
            return;
        }
        this.log(msg.getStartLine());
        this.log("Headers:");
        this.log(msg.getHeader().toString());
        if (this.headerOnly) {
            this.log("================");
            return;
        }
        this.log("Body:");
        if (msg.isBodyEmpty()) {
            this.log("empty");
            this.log("================");
            return;
        }
        if (msg.isImage()) {
            this.log("[binary image data]");
            this.log("================");
            return;
        }
        this.log(msg.getBodyAsStringDecoded());
        this.log("================");
    }

    private void log(String msg) {
        switch (this.level) {
            case TRACE: {
                LoggerFactory.getLogger((String)this.category).trace(msg);
                break;
            }
            case DEBUG: {
                LoggerFactory.getLogger((String)this.category).debug(msg);
                break;
            }
            case INFO: {
                LoggerFactory.getLogger((String)this.category).info(msg);
                break;
            }
            case WARN: {
                LoggerFactory.getLogger((String)this.category).warn(msg);
                break;
            }
            case ERROR: {
                LoggerFactory.getLogger((String)this.category).error(msg);
                break;
            }
            case FATAL: {
                LoggerFactory.getLogger((String)this.category).error(msg);
            }
        }
    }

    public String getCategory() {
        return this.category;
    }

    @MCAttribute
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getShortDescription() {
        return "Logs the " + (this.headerOnly ? "headers of " : "") + "requests and responses using Log4J's " + this.level.toString() + " level.";
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

