/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.multipart.XOPReconstitutor;
import java.io.IOException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

@MCElement(name="analyser")
public class MessageAnalyser
extends AbstractInterceptor {
    public static final String REQUEST_ROOT_ELEMENT_NAME = "MEMRequestRootElementName";
    public static final String REQUEST_ROOT_ELEMENT_NS = "MEMRequestRootElementNS";
    public static final String REQUEST_SOAP_VERSION = "MEMRequestSoapVersion";
    public static final String REQUEST_SOAP_OPERATION = "MEMRequestSoapOperation";
    public static final String REQUEST_SOAP_OPERATION_NS = "MEMRequestSoapOperationNS";
    public static final String RESPONSE_ROOT_ELEMENT_NAME = "MEMResponseRootElementName";
    public static final String RESPONSE_ROOT_ELEMENT_NS = "MEMResponseRootElementNS";
    public static final String RESPONSE_SOAP_VERSION = "MEMResponseSoapVersion";
    public static final String RESPONSE_SOAP_OPERATION = "MEMResponseSoapOperation";
    public static final String RESPONSE_SOAP_OPERATION_NS = "MEMResponseSoapOperationNS";
    private static final XOPReconstitutor xopr = new XOPReconstitutor();
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    public MessageAnalyser() {
        this.name = "Message Analyser";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription();
    }

    @Override
    public String getShortDescription() {
        return "Extracts Information about the XML from the message.";
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        ExtractedData data = this.analyse(exc.getRequest());
        if (!data.hasAnyData()) {
            return Outcome.CONTINUE;
        }
        exc.setProperty(REQUEST_ROOT_ELEMENT_NAME, data.rootElementName);
        exc.setProperty(REQUEST_ROOT_ELEMENT_NS, data.rootElementNS);
        if (!data.hasSoapData()) {
            return Outcome.CONTINUE;
        }
        exc.setProperty(REQUEST_SOAP_OPERATION, data.bodyContentElementName);
        exc.setProperty(REQUEST_SOAP_OPERATION_NS, data.bodyContentElementNS);
        exc.setProperty(REQUEST_SOAP_VERSION, data.getSoapVersion());
        return Outcome.CONTINUE;
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        ExtractedData data = this.analyse(exc.getResponse());
        if (!data.hasAnyData()) {
            return Outcome.CONTINUE;
        }
        exc.setProperty(RESPONSE_ROOT_ELEMENT_NAME, data.rootElementName);
        exc.setProperty(RESPONSE_ROOT_ELEMENT_NS, data.rootElementNS);
        if (!data.hasSoapData()) {
            return Outcome.CONTINUE;
        }
        exc.setProperty(RESPONSE_SOAP_OPERATION, data.bodyContentElementName.replace("Response", ""));
        exc.setProperty(RESPONSE_SOAP_OPERATION_NS, data.bodyContentElementNS);
        exc.setProperty(RESPONSE_SOAP_VERSION, data.getSoapVersion());
        return Outcome.CONTINUE;
    }

    private ExtractedData analyse(Message msg) throws Exception {
        ExtractedData res = new ExtractedData();
        if (msg.isBodyEmpty() && !msg.isXML()) {
            return res;
        }
        XMLStreamReader reader = this.getReader(msg);
        this.extractRootNameAndNS(reader, res);
        if (!res.hasSoapData()) {
            return res;
        }
        this.moveToSoapBody(reader);
        this.extractBodyContentNameAndNS(reader, res);
        return res;
    }

    private void moveToTag(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            reader.next();
            if (!reader.isStartElement()) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLStreamReader getReader(Message msg) throws XMLStreamException, FactoryConfigurationError, IOException {
        XMLInputFactory xMLInputFactory = xmlInputFactory;
        synchronized (xMLInputFactory) {
            return xmlInputFactory.createXMLStreamReader(xopr.reconstituteIfNecessary(msg));
        }
    }

    private void extractRootNameAndNS(XMLStreamReader reader, ExtractedData res) throws XMLStreamException {
        this.moveToTag(reader);
        res.rootElementName = reader.getName().getLocalPart();
        res.rootElementNS = reader.getNamespaceURI();
    }

    private void extractBodyContentNameAndNS(XMLStreamReader reader, ExtractedData res) throws XMLStreamException {
        this.moveToTag(reader);
        res.bodyContentElementName = reader.getName().getLocalPart();
        res.bodyContentElementNS = reader.getNamespaceURI();
    }

    private void moveToSoapBody(XMLStreamReader reader) throws XMLStreamException {
        while (this.hasNextAndIsNotBody(reader)) {
            this.moveToTag(reader);
        }
    }

    private boolean hasNextAndIsNotBody(XMLStreamReader reader) throws XMLStreamException {
        return reader.hasNext() && (!reader.isStartElement() || !"Body".equals(reader.getName().getLocalPart()) || !"http://schemas.xmlsoap.org/soap/envelope/".equals(reader.getNamespaceURI()));
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
    }

    private static class ExtractedData {
        public String rootElementName;
        public String rootElementNS;
        public String bodyContentElementName;
        public String bodyContentElementNS;

        private ExtractedData() {
        }

        public String getSoapVersion() {
            return "http://schemas.xmlsoap.org/soap/envelope/".equals(this.rootElementNS) ? "1.1" : "http://www.w3.org/2003/05/soap-envelope";
        }

        public boolean hasAnyData() {
            return this.rootElementName != null;
        }

        public boolean hasSoapData() {
            return "Envelope".equals(this.rootElementName) && ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.rootElementNS) || "http://www.w3.org/2003/05/soap-envelope".equals(this.rootElementNS));
        }
    }
}

