/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.EmptyBody;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import java.io.IOException;

@MCElement(name="methodOverride")
public class MethodOverrideInterceptor
extends AbstractInterceptor {
    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        String methodHeader = exc.getRequest().getHeader().getFirstValue("X-HTTP-Method-Override");
        if (methodHeader == null) {
            return Outcome.CONTINUE;
        }
        switch (methodHeader) {
            case "GET": {
                this.handleGet(exc);
            }
        }
        exc.getRequest().getHeader().removeFields("X-HTTP-Method-Override");
        return Outcome.CONTINUE;
    }

    private void handleGet(Exchange exc) throws IOException {
        Request req = exc.getRequest();
        req.readBody();
        req.setBody(new EmptyBody());
        req.getHeader().removeFields("Content-Length");
        req.getHeader().removeFields("Content-Type");
        req.setMethod("GET");
    }
}

