/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.DispatchingInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.InterceptorFlowController;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.RuleMatchingInterceptor;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.util.URLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="userFeature")
public class UserFeatureInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)UserFeatureInterceptor.class.getName());
    private static final InterceptorFlowController flowController = new InterceptorFlowController();

    public UserFeatureInterceptor() {
        this.name = "User Feature";
        this.setFlow(Interceptor.Flow.Set.REQUEST);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        Rule predecessorRule = exc.getRule();
        Outcome outcome = flowController.invokeRequestHandlers(exc, predecessorRule.getInterceptors());
        while (this.isTargetInternalAndContinue(exc, outcome)) {
            log.debug("routing to serviceProxy with name: " + this.getServiceProxyName(exc));
            String destination = exc.getDestinations().get(0);
            Rule newRule = this.getRuleByDest(destination);
            if (newRule == null) {
                throw new Exception("No proxy found for destination " + destination);
            }
            RuleMatchingInterceptor.assignRule(exc, newRule);
            exc.getDestinations().clear();
            exc.getDestinations().add(DispatchingInterceptor.getForwardingDestination(this.router.getUriFactory(), exc));
            outcome = flowController.invokeRequestHandlers(exc, newRule.getInterceptors());
        }
        exc.setRule(predecessorRule);
        return outcome;
    }

    private String getServiceProxyName(Exchange exc) {
        return exc.getDestinations().get(0).substring(8);
    }

    private boolean isTargetInternalAndContinue(Exchange exc, Outcome outcome) {
        return outcome == Outcome.CONTINUE && exc.getDestinations().get(0).startsWith("service:");
    }

    private Rule getRuleByDest(String dest) {
        return this.router.getRuleManager().getRuleByName(URLUtil.getHost(dest));
    }
}

