/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.RelocatingInterceptor;
import com.predic8.membrane.core.ws.relocator.Relocator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="wadlRewriter")
public class WADLInterceptor
extends RelocatingInterceptor {
    private static Logger log = LoggerFactory.getLogger((String)WADLInterceptor.class.getName());

    public WADLInterceptor() {
        this.name = "WADL Rewriting Interceptor";
        this.setFlow(Interceptor.Flow.Set.RESPONSE);
    }

    @Override
    protected void rewrite(Exchange exc) throws Exception, IOException {
        log.debug("Changing endpoint address in WADL");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Relocator relocator = new Relocator(new OutputStreamWriter((OutputStream)stream, exc.getResponse().getCharset()), this.getLocationProtocol(), this.getLocationHost(exc), this.getLocationPort(exc), exc.getHandler().getContextPath(exc), this.pathRewriter);
        relocator.getRelocatingAttributes().put(new QName("http://wadl.dev.java.net/2009/02", "resources"), "base");
        relocator.getRelocatingAttributes().put(new QName("http://wadl.dev.java.net/2009/02", "include"), "href");
        relocator.relocate(new InputStreamReader(exc.getResponse().getBodyAsStreamDecoded(), exc.getResponse().getCharset()));
        exc.getResponse().setBodyContent(stream.toByteArray());
    }

    @Override
    @MCAttribute
    public void setProtocol(String protocol) {
        super.setProtocol(protocol);
    }

    @Override
    @MCAttribute
    public void setHost(String host) {
        super.setHost(host);
    }

    @Override
    @MCAttribute
    public void setPort(String port) {
        super.setPort(port);
    }
}

