/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.googlecode.jatl.Html;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.RelocatingInterceptor;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.util.MessageUtil;
import com.predic8.membrane.core.ws.relocator.Relocator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="wsdlRewriter")
public class WSDLInterceptor
extends RelocatingInterceptor {
    private static Logger log = LoggerFactory.getLogger((String)WSDLInterceptor.class.getName());
    private String registryWSDLRegisterURL;
    private boolean rewriteEndpoint = true;
    private HttpClient hc;

    public WSDLInterceptor() {
        this.name = "WSDL Rewriting Interceptor";
        this.setFlow(Interceptor.Flow.Set.RESPONSE);
    }

    @Override
    public void init(Router router) throws Exception {
        super.init(router);
        this.hc = router.getHttpClientFactory().createClient(null);
    }

    @Override
    protected void rewrite(Exchange exc) throws Exception, IOException {
        log.debug("Changing endpoint address in WSDL");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Relocator relocator = new Relocator(new OutputStreamWriter((OutputStream)stream, exc.getResponse().getCharset()), this.getLocationProtocol(), this.getLocationHost(exc), this.getLocationPort(exc), exc.getHandler().getContextPath(exc), this.pathRewriter);
        if (this.rewriteEndpoint) {
            relocator.getRelocatingAttributes().put(new QName("http://schemas.xmlsoap.org/wsdl/soap/", "address"), "location");
            relocator.getRelocatingAttributes().put(new QName("http://schemas.xmlsoap.org/wsdl/soap12/", "address"), "location");
            relocator.getRelocatingAttributes().put(new QName("http://schemas.xmlsoap.org/wsdl/http/", "address"), "location");
        }
        relocator.getRelocatingAttributes().put(new QName("http://www.w3.org/2001/XMLSchema", "import"), "schemaLocation");
        relocator.getRelocatingAttributes().put(new QName("http://www.w3.org/2001/XMLSchema", "include"), "schemaLocation");
        relocator.relocate(new InputStreamReader(exc.getResponse().getBodyAsStreamDecoded(), exc.getResponse().getCharset()));
        if (relocator.isWsdlFound()) {
            this.registerWSDL(exc);
        }
        exc.getResponse().setBodyContent(stream.toByteArray());
    }

    private void registerWSDL(Exchange exc) {
        if (this.registryWSDLRegisterURL == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.registryWSDLRegisterURL);
        buf.append("?wsdl=");
        try {
            buf.append(URLDecoder.decode(this.getWSDLURL(exc), "US-ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.callRegistry(buf.toString());
        log.debug(buf.toString());
    }

    private void callRegistry(String uri) {
        try {
            Response res = this.hc.call(this.createExchange(uri)).getResponse();
            if (res.getStatusCode() != 200) {
                log.warn("{}", (Object)res);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    private Exchange createExchange(String uri) throws MalformedURLException {
        URL url = new URL(uri);
        Request req = MessageUtil.getGetRequest(this.getCompletePath(url));
        req.getHeader().setHost(url.getHost());
        Exchange exc = new Exchange(null);
        exc.setRequest(req);
        exc.getDestinations().add(uri);
        return exc;
    }

    private String getCompletePath(URL url) {
        if (url.getQuery() == null) {
            return url.getPath();
        }
        return url.getPath() + "?" + url.getQuery();
    }

    private String getWSDLURL(Exchange exc) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getLocationProtocol());
        buf.append("://");
        buf.append(this.getLocationHost(exc));
        if (this.getLocationPort(exc) != 80) {
            buf.append(":");
            buf.append(this.getLocationPort(exc));
        }
        buf.append("/");
        buf.append(exc.getRequest().getUri());
        return buf.toString();
    }

    @MCAttribute
    public void setRegistryWSDLRegisterURL(String registryWSDLRegisterURL) {
        this.registryWSDLRegisterURL = registryWSDLRegisterURL;
    }

    public String getRegistryWSDLRegisterURL() {
        return this.registryWSDLRegisterURL;
    }

    @Override
    public String getShortDescription() {
        return "Rewrites SOAP endpoint addresses and XML Schema locations in WSDL and XSD documents.";
    }

    @Override
    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getShortDescription());
        sb.append("<br/>");
        sb.append("The protocol, host and port of the incoming request will be used for the substitution");
        if (this.protocol != null || this.port != null || this.host != null) {
            sb.append(" except the following fixed values:");
            StringWriter sw = new StringWriter();
            new Html(sw){
                {
                    this.table();
                    this.thead();
                    this.tr();
                    ((Html)((Html)this.th()).text("Part")).end();
                    ((Html)((Html)this.th()).text("Value")).end();
                    this.end();
                    this.end();
                    this.tbody();
                    if (WSDLInterceptor.this.protocol != null) {
                        this.tr();
                        ((Html)((Html)this.td()).text("Protocol")).end();
                        ((Html)((Html)this.td()).text(WSDLInterceptor.this.protocol)).end();
                        this.end();
                    }
                    if (WSDLInterceptor.this.host != null) {
                        this.tr();
                        ((Html)((Html)this.td()).text("Host")).end();
                        ((Html)((Html)this.td()).text(WSDLInterceptor.this.host)).end();
                        this.end();
                    }
                    if (WSDLInterceptor.this.port != null) {
                        this.tr();
                        ((Html)((Html)this.td()).text("Port")).end();
                        ((Html)((Html)this.td()).text(WSDLInterceptor.this.port)).end();
                        this.end();
                    }
                    this.end();
                    this.end();
                }
            };
            sb.append(sw.toString());
        } else {
            sb.append(".");
        }
        return sb.toString();
    }

    public void setRewriteEndpoint(boolean rewriteEndpoint) {
        this.rewriteEndpoint = rewriteEndpoint;
    }

    @Override
    @MCAttribute
    public void setProtocol(String protocol) {
        super.setProtocol(protocol);
    }

    @Override
    @MCAttribute
    public void setHost(String host) {
        super.setHost(host);
    }

    @Override
    @MCAttribute
    public void setPort(String port) {
        super.setPort(port);
    }
}

