/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.apimanagement.apiconfig;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.cloud.ExponentialBackoff;
import com.predic8.membrane.core.cloud.etcd.EtcdNodeInformation;
import com.predic8.membrane.core.cloud.etcd.EtcdRequest;
import com.predic8.membrane.core.cloud.etcd.EtcdResponse;
import com.predic8.membrane.core.config.spring.BaseLocationApplicationContext;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.administration.AdminConsoleInterceptor;
import com.predic8.membrane.core.interceptor.apimanagement.ApiManagementConfiguration;
import com.predic8.membrane.core.interceptor.apimanagement.apiconfig.ApiConfig;
import com.predic8.membrane.core.rules.AbstractServiceProxy;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.rules.ServiceProxy;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.Lifecycle;

@MCElement(name="etcdRegistryApiConfig")
public class EtcdRegistryApiConfig
implements Lifecycle,
ApplicationContextAware,
ApiConfig,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger((String)EtcdRegistryApiConfig.class.getName());
    private ApplicationContext context;
    private ApiManagementConfiguration amc;
    private String url;
    private String membraneId;
    private String baseKeyPrefix = "/membrane/";
    private int ttl = 300;
    private int retryDelayMin = 10000;
    private int retryDelayMax = 600000;
    private double expDelayFactor = 2.0;
    Thread publisher = new Thread(new Runnable(){
        int sleepTime;
        {
            this.sleepTime = (EtcdRegistryApiConfig.this.ttl - 10) * 1000;
        }

        @Override
        public void run() {
            try {
                boolean connectionLost = false;
                while (true) {
                    String baseKey;
                    EtcdResponse respTTLDirRefresh;
                    if (!(respTTLDirRefresh = EtcdRequest.create(EtcdRegistryApiConfig.this.url, baseKey = EtcdRegistryApiConfig.this.baseKeyPrefix + EtcdRegistryApiConfig.this.membraneId, "").refreshTTL(EtcdRegistryApiConfig.this.ttl).sendRequest()).is2XX()) {
                        log.warn("Could not contact etcd at " + EtcdRegistryApiConfig.this.url);
                        connectionLost = true;
                    }
                    Thread.sleep(this.sleepTime);
                    if (!connectionLost) continue;
                    log.warn("Connection lost to etcd");
                    ExponentialBackoff.retryAfter(EtcdRegistryApiConfig.this.retryDelayMin, EtcdRegistryApiConfig.this.retryDelayMax, EtcdRegistryApiConfig.this.expDelayFactor, "Republish from thread after failed ttl refresh", EtcdRegistryApiConfig.this.jobPublisher);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    });
    ExponentialBackoff.Job jobPublisher = new ExponentialBackoff.Job(){

        @Override
        public boolean run() throws Exception {
            return EtcdRegistryApiConfig.this.publishToEtcd();
        }
    };

    private boolean publishToEtcd() {
        String baseKey = this.baseKeyPrefix + this.membraneId;
        EtcdResponse respPublishApiUrl = EtcdRequest.create(this.url, baseKey, "/apiconfig").setValue("url", "").sendRequest();
        if (!respPublishApiUrl.is2XX()) {
            System.out.println(respPublishApiUrl.getBody());
            return false;
        }
        EtcdResponse respPublishApiFingerprint = EtcdRequest.create(this.url, baseKey, "/apiconfig").setValue("fingerprint", "").sendRequest();
        if (!respPublishApiFingerprint.is2XX()) {
            System.out.println(respPublishApiFingerprint.getBody());
            return false;
        }
        EtcdNodeInformation adminConsole = this.findAdminConsole();
        EtcdResponse respPublishEndpointName = EtcdRequest.create(this.url, baseKey, "/endpoint").setValue("name", adminConsole.getName()).sendRequest();
        if (!respPublishEndpointName.is2XX()) {
            System.out.println(respPublishEndpointName.getBody());
            return false;
        }
        EtcdResponse respPublishEndpointHost = EtcdRequest.create(this.url, baseKey, "/endpoint").setValue("host", adminConsole.getTargetHost()).sendRequest();
        if (!respPublishEndpointHost.is2XX()) {
            System.out.println(respPublishEndpointHost.getBody());
            return false;
        }
        EtcdResponse respPublishEndpointPort = EtcdRequest.create(this.url, baseKey, "/endpoint").setValue("port", adminConsole.getTargetPort()).sendRequest();
        if (!respPublishEndpointPort.is2XX()) {
            System.out.println(respPublishEndpointPort.getBody());
            return false;
        }
        return true;
    }

    private EtcdNodeInformation findAdminConsole() {
        Object routerObj = this.context.getBean(Router.class);
        if (routerObj == null) {
            throw new RuntimeException("Router not found, cannot publish admin console");
        }
        Router router = (Router)routerObj;
        for (Rule r : router.getRuleManager().getRules()) {
            if (!(r instanceof AbstractServiceProxy)) continue;
            for (Interceptor i : r.getInterceptors()) {
                if (!(i instanceof AdminConsoleInterceptor)) continue;
                String name = r.getName();
                String host = ((ServiceProxy)r).getExternalHostname();
                if (host == null) {
                    host = this.getLocalHostname();
                }
                String port = Integer.toString(((AbstractServiceProxy)r).getPort());
                EtcdNodeInformation node = new EtcdNodeInformation(null, null, host, port, name);
                return node;
            }
        }
        throw new RuntimeException("Admin console not found but is needed. Add a service proxy with an admin console.");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void start() {
        Object routerObj = this.context.getBean(Router.class);
        if (routerObj == null) {
            throw new RuntimeException("Router cannot be found");
        }
        Router router = (Router)routerObj;
        this.membraneId = router.getId();
        try {
            log.info("Started membrane publishing");
            ExponentialBackoff.retryAfter(this.retryDelayMin, this.retryDelayMax, this.expDelayFactor, "First publish from thread", this.jobPublisher);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.initAmc();
        if (!this.publisher.isAlive()) {
            this.publisher.start();
        }
    }

    public void initAmc() {
        String workingDir = ((BaseLocationApplicationContext)this.context).getBaseLocation();
        String etcdUrlForAmc = null;
        URL u = null;
        try {
            u = new URL(this.getUrl());
        }
        catch (MalformedURLException e) {
            try {
                u = new URL("http://" + this.getUrl());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (u == null) {
            log.error("Url malformed: " + this.getUrl());
        }
        etcdUrlForAmc = "etcd://" + u.getHost() + ":" + u.getPort();
        this.amc = new ApiManagementConfiguration(workingDir, etcdUrlForAmc, this.membraneId);
    }

    public void stop() {
        this.amc.shutdown();
    }

    public boolean isRunning() {
        return false;
    }

    public String getUrl() {
        return this.url;
    }

    @MCAttribute
    public void setUrl(String url) {
        this.url = url;
    }

    public int getTtl() {
        return this.ttl;
    }

    @MCAttribute
    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    @Override
    public ApiManagementConfiguration getConfiguration() {
        return this.amc;
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public String getLocalHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            try {
                return IOUtils.toString((InputStream)Runtime.getRuntime().exec("hostname").getInputStream());
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return "localhost";
            }
        }
    }
}

