/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.apimanagement.rateLimiter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.apimanagement.ApiManagementConfiguration;
import com.predic8.membrane.core.interceptor.apimanagement.Key;
import com.predic8.membrane.core.interceptor.apimanagement.policy.Policy;
import com.predic8.membrane.core.interceptor.apimanagement.rateLimiter.ApiKeyRequestCounter;
import com.predic8.membrane.core.interceptor.apimanagement.rateLimiter.LimitReachedAnswer;
import com.predic8.membrane.core.interceptor.apimanagement.rateLimiter.PolicyRateLimit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.PeriodFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="amRateLimiter")
public class AMRateLimiter {
    private static Logger log = LoggerFactory.getLogger(AMRateLimiter.class);
    private ApiManagementConfiguration amc;
    public ConcurrentHashMap<String, ApiKeyRequestCounter> keyInformation = new ConcurrentHashMap();
    public ConcurrentHashMap<String, PolicyRateLimit> policyRateLimits = new ConcurrentHashMap();
    private Runnable observer = new Runnable(){

        @Override
        public void run() {
            log.info("Getting new config");
            AMRateLimiter.this.keyInformation = new ConcurrentHashMap();
            AMRateLimiter.this.fillPolicyCleanupTimes();
        }
    };

    public ApiManagementConfiguration getAmc() {
        return this.amc;
    }

    public void setAmc(ApiManagementConfiguration amc) {
        if (this.amc != null) {
            this.amc.configChangeObservers.remove(this.observer);
        }
        this.amc = amc;
        this.fillPolicyCleanupTimes();
        amc.configChangeObservers.add(this.observer);
    }

    private void fillPolicyCleanupTimes() {
        this.policyRateLimits.clear();
        for (Policy policy : this.amc.getPolicies().values()) {
            String name = policy.getName();
            int requests = policy.getRateLimit().getRequests();
            Duration interval = Duration.standardSeconds((long)policy.getRateLimit().getInterval());
            HashSet<String> services = new HashSet<String>(policy.getServiceProxies());
            PolicyRateLimit prl = new PolicyRateLimit();
            prl.setName(name);
            prl.setRequests(requests);
            prl.setInterval(interval);
            prl.setServices(services);
            prl.incrementNextCleanup();
            this.policyRateLimits.put(name, prl);
        }
    }

    public Outcome handleRequest(Exchange exc) throws Exception {
        Object keyObj = exc.getProperty("API_KEY");
        if (keyObj == null) {
            log.warn("No api key set in exchange");
            return Outcome.RETURN;
        }
        String apiKey = (String)keyObj;
        String service = exc.getRule().getName();
        LimitReachedAnswer answer = this.isRequestLimitReached(service, apiKey);
        if (answer.isLimitReached()) {
            this.setResponseToServiceUnavailable(exc, answer.getPrl());
            return Outcome.RETURN;
        }
        return Outcome.CONTINUE;
    }

    public void setResponseToServiceUnavailable(Exchange exc, PolicyRateLimit prl) throws UnsupportedEncodingException {
        Header hd = new Header();
        DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withZoneUTC().withLocale(Locale.US);
        hd.add("Date", dateFormatter.print((ReadableInstant)DateTime.now()));
        hd.add("X-LimitDuration", PeriodFormat.getDefault().print((ReadablePeriod)prl.getInterval().toPeriod()));
        hd.add("X-LimitRequests", Integer.toString(prl.getRequests()));
        String ip = exc.getRemoteAddrIp();
        DateTime availableAgainDateTime = prl.getNextCleanup();
        hd.add("X-LimitReset", Long.toString(availableAgainDateTime.getMillis()));
        DateTimeFormatter dtFormatter = DateTimeFormat.forPattern((String)"HH:mm:ss aa");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JsonGenerator jgen = null;
        try {
            jgen = new JsonFactory().createGenerator((OutputStream)os);
            jgen.writeStartObject();
            jgen.writeObjectField("Statuscode", (Object)429);
            jgen.writeObjectField("Message", (Object)("The rate limit of " + prl.getRequests() + " requests in " + prl.getInterval().getStandardSeconds() + " seconds is exceeded. The next requests can be made at " + dtFormatter.print((ReadableInstant)availableAgainDateTime)));
            jgen.writeEndObject();
            jgen.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Response resp = Response.ResponseBuilder.newInstance().status(429, "Too Many Requests.").header(hd).contentType("application/json").body(os.toByteArray()).build();
        exc.setResponse(resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimitReachedAnswer isRequestLimitReached(String service, String apiKey) {
        this.doCleanup();
        this.addRequestEntry(apiKey);
        ApiKeyRequestCounter info = this.keyInformation.get(apiKey);
        boolean resultTemp = false;
        PolicyRateLimit prlTemp = null;
        ApiKeyRequestCounter apiKeyRequestCounter = info;
        synchronized (apiKeyRequestCounter) {
            for (String policy : info.getPolicyCounters().keySet()) {
                PolicyRateLimit prl = this.policyRateLimits.get(policy);
                if (!prl.getServices().contains(service)) continue;
                if (info.getPolicyCounters().get(policy).get() > prl.getRequests()) {
                    resultTemp = true;
                    prlTemp = prl;
                    continue;
                }
                resultTemp = false;
                break;
            }
        }
        if (resultTemp) {
            return LimitReachedAnswer.createLimitReached(prlTemp);
        }
        return LimitReachedAnswer.createLimitNotReached();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanup() {
        ConcurrentHashMap<String, PolicyRateLimit> concurrentHashMap = this.policyRateLimits;
        synchronized (concurrentHashMap) {
            for (PolicyRateLimit prl : this.policyRateLimits.values()) {
                if (!DateTime.now().isAfter((ReadableInstant)prl.getNextCleanup())) continue;
                for (ApiKeyRequestCounter keyInfo : this.keyInformation.values()) {
                    if (!keyInfo.getPolicyCounters().keySet().contains(prl.getName())) continue;
                    keyInfo.getPolicyCounters().get(prl.getName()).set(0);
                }
                prl.incrementNextCleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequestEntry(String apiKey) {
        ConcurrentHashMap<String, ApiKeyRequestCounter> concurrentHashMap = this.keyInformation;
        synchronized (concurrentHashMap) {
            if (!this.keyInformation.containsKey(apiKey)) {
                ApiKeyRequestCounter value = new ApiKeyRequestCounter();
                Key key = this.amc.getKeys().get(apiKey);
                for (Policy p : key.getPolicies()) {
                    value.getPolicyCounters().put(p.getName(), new AtomicInteger());
                }
                this.keyInformation.put(apiKey, value);
            }
        }
        ApiKeyRequestCounter keyInfo = this.keyInformation.get(apiKey);
        for (AtomicInteger counter : keyInfo.getPolicyCounters().values()) {
            counter.incrementAndGet();
        }
    }
}

