/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.apimanagement.statistics;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.model.AbstractExchangeViewerListener;
import com.predic8.membrane.core.rules.StatisticCollector;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="amStatisticsCollector")
public class AMStatisticsCollector {
    private static Logger log = LoggerFactory.getLogger(AMStatisticsCollector.class);
    public static final String API_STATISTICS_PATH = "/api/statistics/";
    public static final String API_EXCHANGES_PATH = "/api/exchanges/";
    boolean shutdown = false;
    private int collectTimeInSeconds = 10;
    static final String localHostname;
    static final long startTime;
    private AtomicInteger runningId = new AtomicInteger(0);
    String host = "localhost";
    private String clientId = null;
    private String clientSecret = null;
    JsonFactory jsonFactory = new JsonFactory();
    ByteArrayOutputStream baos = new ByteArrayOutputStream();
    JsonGenerator jsonGenerator;
    HttpClient client;
    boolean traceStatistics = true;
    boolean traceExchanges = true;
    boolean traceIncludesHeader = true;
    int bodyBytes = -1;
    ConcurrentHashMap<String, ConcurrentLinkedQueue<Exchange>> exchangesForApiKey = new ConcurrentHashMap();
    ExecutorService collectorThread = Executors.newFixedThreadPool(1);

    public AMStatisticsCollector() {
        HttpClientConfiguration conf = new HttpClientConfiguration();
        this.client = new HttpClient(conf);
        try {
            this.jsonGenerator = this.jsonFactory.createGenerator((OutputStream)this.baos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.collectorThread.submit(new Runnable(){

            @Override
            public void run() {
                block6: while (true) {
                    try {
                        while (true) {
                            Exchange exc = null;
                            ArrayList<String> jsonStatisticsForApiKey = new ArrayList<String>();
                            ArrayList<String> jsonExchangesForApiKey = new ArrayList<String>();
                            for (String apiKey : AMStatisticsCollector.this.exchangesForApiKey.keySet()) {
                                while ((exc = AMStatisticsCollector.this.exchangesForApiKey.get(apiKey).poll()) != null) {
                                    String exchangeStatistics = null;
                                    String exchangeData = null;
                                    if (AMStatisticsCollector.this.traceStatistics) {
                                        try {
                                            exchangeStatistics = AMStatisticsCollector.this.collectStatisticFrom(exc, apiKey);
                                            jsonStatisticsForApiKey.add(exchangeStatistics);
                                        }
                                        catch (Exception ignored) {
                                            continue;
                                        }
                                    }
                                    if (!AMStatisticsCollector.this.traceExchanges) continue;
                                    try {
                                        exchangeData = AMStatisticsCollector.this.collectExchangeDataFrom(exc, apiKey);
                                        jsonExchangesForApiKey.add(exchangeData);
                                    }
                                    catch (Exception ignored) {}
                                }
                            }
                            if (!jsonStatisticsForApiKey.isEmpty()) {
                                AMStatisticsCollector.this.sendJsonToElasticSearch(AMStatisticsCollector.API_STATISTICS_PATH, AMStatisticsCollector.this.combineJsons(localHostname, jsonStatisticsForApiKey));
                            }
                            if (!jsonExchangesForApiKey.isEmpty()) {
                                AMStatisticsCollector.this.sendJsonToElasticSearch(AMStatisticsCollector.API_EXCHANGES_PATH, AMStatisticsCollector.this.combineJsons(localHostname, jsonExchangesForApiKey));
                            }
                            AMStatisticsCollector.this.runningId.incrementAndGet();
                            if (AMStatisticsCollector.this.shutdown) break block6;
                            Thread.sleep(AMStatisticsCollector.this.getCollectTimeInSeconds() * 1000);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
    }

    private String collectExchangeDataFrom(Exchange exc, String apiKey) throws IOException {
        JsonGenerator gen = this.getAndResetJsonGenerator();
        try {
            gen.writeStartObject();
            gen.writeObjectField("excId", (Object)exc.getId());
            gen.writeObjectField("excTime", (Object)exc.getTime().toInstant().toString());
            gen.writeObjectField("excApiKey", (Object)apiKey);
            gen.writeObjectField("service", (Object)exc.getRule().getName());
            gen.writeObjectField("uri", (Object)exc.getOriginalRequestUri());
            gen.writeObjectField("method", (Object)exc.getRequest().getMethod());
            gen.writeObjectFieldStart("Request");
            this.collectFromMessage(gen, exc.getRequest());
            gen.writeEndObject();
            gen.writeObjectFieldStart("Response");
            this.collectFromMessage(gen, exc.getResponse());
            gen.writeEndObject();
            gen.writeEndObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.getStringFromJsonGenerator();
    }

    private void collectFromMessage(JsonGenerator gen, Message msg) {
        try {
            String body;
            if (this.traceIncludesHeader && msg.getHeader().getAllHeaderFields().length > 0) {
                gen.writeObjectFieldStart("headers");
                for (HeaderField hf : msg.getHeader().getAllHeaderFields()) {
                    gen.writeObjectField(hf.getHeaderName().toString(), (Object)hf.getValue());
                }
                gen.writeEndObject();
            }
            if ((body = this.getBody(msg)).length() > 0) {
                gen.writeObjectField("body", (Object)body);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getBody(Message msg) {
        String origBody = msg.getBodyAsStringDecoded();
        if (this.bodyBytes == -1) {
            return origBody.substring(0, origBody.length());
        }
        return origBody.substring(0, this.bodyBytes);
    }

    private String getLocalMachineNameWithSuffix() {
        return localHostname + "-" + startTime + "-" + this.runningId.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendJsonToElasticSearch(String path, String json) throws Exception {
        Response resp = null;
        HttpClient httpClient = this.client;
        synchronized (httpClient) {
            Exchange exc = new Request.Builder().put(this.getElasticSearchPath(path)).body(json).buildExchange();
            if (this.clientId != null && this.clientSecret != null) {
                exc.getRequest().getHeader().add("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])(this.clientId + ":" + this.clientSecret).getBytes("UTF-8")), "UTF-8"));
            }
            resp = this.client.call(exc).getResponse();
        }
        if (!resp.isOk()) {
            log.warn("Could not send statistics to elastic search instance. Response: " + resp.getStatusCode() + " - " + resp.getStatusMessage() + " - " + resp.getBodyAsStringDecoded());
        }
    }

    private String combineJsons(String name, ArrayList<String> jsonStatisticsForRequests) throws IOException {
        JsonGenerator gen = this.getAndResetJsonGenerator();
        try {
            gen.writeStartObject();
            gen.writeArrayFieldStart(name);
            if (!jsonStatisticsForRequests.isEmpty()) {
                gen.writeRaw(jsonStatisticsForRequests.get(0));
            }
            for (int i = 1; i < jsonStatisticsForRequests.size(); ++i) {
                gen.writeRaw("," + jsonStatisticsForRequests.get(i));
            }
            gen.writeEndArray();
            gen.writeEndObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.getStringFromJsonGenerator();
    }

    private String collectStatisticFrom(Exchange exc, String apiKey) throws IOException {
        StatisticCollector statistics = new StatisticCollector(false);
        statistics.collectFrom(exc);
        JsonGenerator gen = this.getAndResetJsonGenerator();
        try {
            gen.writeStartObject();
            gen.writeObjectField("excId", (Object)exc.getId());
            gen.writeObjectField("excTime", (Object)exc.getTime().toInstant().toString());
            gen.writeObjectField("excApiKey", (Object)apiKey);
            gen.writeObjectField("service", (Object)exc.getRule().getName());
            gen.writeObjectField("uri", (Object)exc.getOriginalRequestUri());
            gen.writeObjectField("method", (Object)exc.getRequest().getMethod());
            gen.writeObjectField("excStatus", (Object)exc.getStatus().toString());
            gen.writeObjectField("code", (Object)exc.getResponse().getStatusCode());
            gen.writeObjectField("time", (Object)this.getInflightTime(exc));
            gen.writeEndObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.getStringFromJsonGenerator();
    }

    private long getInflightTime(Exchange exc) {
        if (exc.getTimeReqSent() == 0L) {
            return -1L;
        }
        return exc.getTimeResSent() - exc.getTimeReqSent();
    }

    private String getElasticSearchPath(String path) {
        return this.getHost() + this.normalizePath(path) + this.getLocalMachineNameWithSuffix();
    }

    private String normalizePath(String path) {
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return path;
    }

    public Outcome handleRequest(final Exchange exc, Outcome outcome) {
        exc.addExchangeViewerListener(new AbstractExchangeViewerListener(){

            @Override
            public void setExchangeFinished() {
                AMStatisticsCollector.this.addExchangeToQueue(exc);
            }
        });
        return outcome;
    }

    public void addExchangeToQueue(Exchange exc) {
        String apiKey = (String)exc.getProperty("API_KEY");
        if (apiKey != null) {
            ConcurrentLinkedQueue newValue;
            ConcurrentLinkedQueue<Exchange> exchangeQueue = this.exchangesForApiKey.get(apiKey);
            if (exchangeQueue == null && (exchangeQueue = this.exchangesForApiKey.putIfAbsent(apiKey, newValue = new ConcurrentLinkedQueue())) == null) {
                exchangeQueue = newValue;
            }
            exchangeQueue.add(exc);
        }
    }

    public Outcome handleResponse(Exchange exc, Outcome outcome) {
        return outcome;
    }

    public int getCollectTimeInSeconds() {
        return this.collectTimeInSeconds;
    }

    public void setCollectTimeInSeconds(int collectTimeInSeconds) {
        this.collectTimeInSeconds = collectTimeInSeconds;
    }

    public void shutdown() {
        this.shutdown = true;
        try {
            this.collectorThread.shutdown();
            this.collectorThread.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static String getLocalHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            try {
                return IOUtils.toString((InputStream)Runtime.getRuntime().exec("hostname").getInputStream());
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return "localhost";
            }
        }
    }

    protected JsonGenerator getAndResetJsonGenerator() {
        this.baos.reset();
        return this.jsonGenerator;
    }

    protected String getStringFromJsonGenerator() throws IOException {
        this.jsonGenerator.flush();
        return this.baos.toString();
    }

    public String getHost() {
        return this.host;
    }

    @MCAttribute
    public void setHost(String host) {
        this.host = host;
    }

    public String getClientId() {
        return this.clientId;
    }

    @MCAttribute
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    @MCAttribute
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    static {
        startTime = System.currentTimeMillis();
        localHostname = AMStatisticsCollector.getLocalHostname();
    }
}

