/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.authentication.session;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.interceptor.authentication.session.UserDataProvider;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="cachingUserDataProvider", topLevel=false)
public class CachingUserDataProvider
implements UserDataProvider {
    private static final Logger log = LoggerFactory.getLogger((String)CachingUserDataProvider.class.getName());
    private UserDataProvider userDataProvider;
    private Cache<ImmutableMap<String, String>, Boolean> cache;
    private int expireTime;
    private int maxSize;

    @Override
    public Map<String, String> verify(Map<String, String> postData) {
        ImmutableMap temp = ImmutableMap.copyOf(postData);
        Boolean isCached = (Boolean)this.cache.getIfPresent((Object)temp);
        if (isCached != null && isCached.booleanValue()) {
            log.info(String.format("User %s verified through cache", postData.getOrDefault("username", "default")));
            return postData;
        }
        try {
            ImmutableMap res = ImmutableMap.copyOf(this.userDataProvider.verify(postData));
            this.cache.put((Object)temp, (Object)true);
            log.info(String.format("User %s verified through data provider", postData.getOrDefault("username", "default")));
            return res;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoSuchElementException();
        }
    }

    public UserDataProvider getUserDataProvider() {
        return this.userDataProvider;
    }

    @MCChildElement(order=10)
    @Required
    public void setUserDataProvider(UserDataProvider userDataProvider) {
        this.userDataProvider = userDataProvider;
    }

    @Override
    public void init(Router router) {
        this.userDataProvider.init(router);
        this.cache = CacheBuilder.newBuilder().maximumSize((long)this.getMaxSize()).expireAfterWrite((long)this.getExpiryTime(), TimeUnit.MILLISECONDS).build();
    }

    @MCAttribute(attributeName="expiry")
    @Required
    public void setExpiryTime(String expiry) {
        this.expireTime = Integer.parseInt(expiry);
    }

    public int getExpiryTime() {
        return this.expireTime;
    }

    @MCAttribute(attributeName="maxSize")
    @Required
    public void setMaxSize(String maxSize) {
        this.maxSize = Integer.parseInt(maxSize);
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

