/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.authentication.session;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.interceptor.authentication.session.UserDataProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="customStatementJdbcUserDataProvider")
public class CustomStatementJdbcUserDataProvider
implements UserDataProvider {
    private static Logger log = LoggerFactory.getLogger((String)CustomStatementJdbcUserDataProvider.class.getName());
    private Router router;
    DataSource datasource;
    String tableName;
    String userColumnName;
    String passwordColumnName;
    private String checkPasswordSql;
    private String sqlResultAttribute;
    private String userNameAttribute;

    @Override
    public void init(Router router) {
        this.router = router;
        this.sanitizeUserInputs();
        this.getDatasourceIfNull();
    }

    private void sanitizeUserInputs() {
    }

    private void getDatasourceIfNull() {
        if (this.datasource != null) {
            return;
        }
        Map beans = this.router.getBeanFactory().getBeansOfType(DataSource.class);
        DataSource[] datasources = beans.values().toArray(new DataSource[0]);
        if (datasources.length <= 0) {
            throw new RuntimeException("No datasource found - specifiy a DataSource bean in your Membrane configuration");
        }
        this.datasource = datasources[0];
    }

    @Override
    public Map<String, String> verify(Map<String, String> postData) {
        String username = postData.get("username");
        if (username == null) {
            throw new NoSuchElementException();
        }
        String password = postData.get("password");
        if (password == null) {
            throw new NoSuchElementException();
        }
        Connection con = null;
        PreparedStatement preparedStatement = null;
        try {
            con = this.datasource.getConnection();
            preparedStatement = con.prepareStatement(this.checkPasswordSql);
            preparedStatement.setString(1, username);
            preparedStatement.setString(2, password);
            ResultSet rs = preparedStatement.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            HashMap<String, String> result = new HashMap<String, String>();
            if (!rs.next()) {
                throw new NoSuchElementException();
            }
            result.put(this.sqlResultAttribute, rs.getObject(1).toString());
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (con != null) {
                con.close();
            }
            result.put(this.userNameAttribute, username);
            return result;
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw new NoSuchElementException();
        }
    }

    public String getCheckPasswordSql() {
        return this.checkPasswordSql;
    }

    @MCAttribute
    public void setCheckPasswordSql(String checkPasswordSql) {
        this.checkPasswordSql = checkPasswordSql;
    }

    public String getSqlResultAttribute() {
        return this.sqlResultAttribute;
    }

    @MCAttribute
    public void setSqlResultAttribute(String sqlResultAttribute) {
        this.sqlResultAttribute = sqlResultAttribute;
    }

    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    @MCAttribute
    public void setUserNameAttribute(String userNameAttribute) {
        this.userNameAttribute = userNameAttribute;
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    @MCAttribute
    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    public String getTableName() {
        return this.tableName;
    }

    @MCAttribute
    @Required
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getUserColumnName() {
        return this.userColumnName;
    }

    @MCAttribute
    @Required
    public void setUserColumnName(String userColumnName) {
        this.userColumnName = userColumnName;
    }

    public String getPasswordColumnName() {
        return this.passwordColumnName;
    }

    @MCAttribute
    @Required
    public void setPasswordColumnName(String passwordColumnName) {
        this.passwordColumnName = passwordColumnName;
    }
}

