/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.authentication.session;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.interceptor.authentication.session.UserDataProvider;
import com.predic8.membrane.core.interceptor.registration.SecurityUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="jdbcUserDataProvider")
public class JdbcUserDataProvider
implements UserDataProvider {
    private static final Logger log = LoggerFactory.getLogger((String)JdbcUserDataProvider.class.getName());
    private DataSource datasource;
    private String tableName;
    private String userColumnName;
    private String passwordColumnName;
    private Router router;

    @Override
    public void init(Router router) {
        this.router = router;
        this.sanitizeUserInputs();
        this.getDatasourceIfNull();
        try {
            this.createTableIfNeeded();
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error("Something went wrong at jdbcUserDataProvider table creation");
            log.error(e.getMessage());
        }
    }

    private void sanitizeUserInputs() {
    }

    private void createTableIfNeeded() throws SQLException {
        Connection con = null;
        Statement statement = null;
        try {
            con = this.datasource.getConnection();
            statement = con.createStatement();
            statement.executeUpdate(this.getCreateTableSql());
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (con != null) {
                con.close();
            }
        }
    }

    private String getCreateTableSql() {
        return "CREATE TABLE IF NOT EXISTS " + this.getTableName() + "(id bigint NOT NULL PRIMARY KEY AUTO_INCREMENT, " + this.getUserColumnName() + " varchar NOT NULL, " + this.getPasswordColumnName() + " varchar NOT NULL, verified boolean NOT NULL DEFAULT false);";
    }

    private void getDatasourceIfNull() {
        if (this.datasource != null) {
            return;
        }
        Map beans = this.router.getBeanFactory().getBeansOfType(DataSource.class);
        DataSource[] datasources = beans.values().toArray(new DataSource[0]);
        if (datasources.length <= 0) {
            throw new RuntimeException("No datasource found - specifiy a DataSource bean in your Membrane configuration");
        }
        this.datasource = datasources[0];
    }

    @Override
    public Map<String, String> verify(Map<String, String> postData) {
        String username = postData.get("username");
        if (username == null) {
            throw new NoSuchElementException();
        }
        String password = postData.get("password");
        if (password == null) {
            throw new NoSuchElementException();
        }
        Connection con = null;
        PreparedStatement preparedStatement = null;
        HashMap<String, String> result = null;
        try {
            con = this.datasource.getConnection();
            preparedStatement = con.prepareStatement(this.createGetUsersSql());
            preparedStatement.setString(1, username);
            ResultSet rs = preparedStatement.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            result = new HashMap<String, String>();
            while (rs.next()) {
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    result.put(rsmd.getColumnName(i).toLowerCase(), rs.getObject(i).toString());
                }
            }
            rs.close();
            preparedStatement.close();
            con.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        if (result != null && result.size() > 0) {
            String passwordFromDB = (String)result.get(this.getPasswordColumnName().toLowerCase());
            if (!SecurityUtils.isHashedPassword(password)) {
                password = SecurityUtils.createPasswdCompatibleHash(password, SecurityUtils.extractSalt(passwordFromDB));
            }
            if (username.equals(result.get(this.getUserColumnName().toLowerCase())) && password.equals(passwordFromDB)) {
                return result;
            }
        }
        throw new NoSuchElementException();
    }

    private String createGetUsersSql() {
        return "SELECT * FROM " + this.getTableName() + " WHERE " + this.getUserColumnName() + "=?";
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    @MCAttribute
    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    public String getTableName() {
        return this.tableName.toUpperCase();
    }

    @MCAttribute
    @Required
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getUserColumnName() {
        return this.userColumnName.toUpperCase();
    }

    @MCAttribute
    @Required
    public void setUserColumnName(String userColumnName) {
        this.userColumnName = userColumnName;
    }

    public String getPasswordColumnName() {
        return this.passwordColumnName.toUpperCase();
    }

    @MCAttribute
    @Required
    public void setPasswordColumnName(String passwordColumnName) {
        this.passwordColumnName = passwordColumnName;
    }
}

