/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.authentication.session;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.MCTextContent;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.authentication.session.SessionManager;
import java.math.BigInteger;
import java.security.Key;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwk.RsaJwkGenerator;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.lang.JoseException;

@MCElement(name="jwtSessionManager2", mixed=true)
public class JwtSessionManager
extends SessionManager {
    private SecureRandom random = new SecureRandom();
    private RsaJsonWebKey rsaJsonWebKey;
    private String key;

    public String getKey() {
        return this.key;
    }

    @MCTextContent
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public void init(Router router) {
        super.init(router);
        try {
            if (this.key == null) {
                this.rsaJsonWebKey = RsaJwkGenerator.generateJwk((int)2048);
                this.rsaJsonWebKey.setKeyId(new BigInteger(130, this.random).toString(32));
                this.rsaJsonWebKey.setUse("sig");
                this.rsaJsonWebKey.setAlgorithm("RS256");
                throw new RuntimeException("jwtSessionManager/@key is not set. Please use '" + this.rsaJsonWebKey.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE) + "'.");
            }
            Map jwkJsonParsed = JsonUtil.parseJson((String)this.key);
            this.rsaJsonWebKey = new RsaJsonWebKey(jwkJsonParsed);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected SessionManager.Session validateAndReconstructSession(String singedSession) {
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setRequireExpirationTime().setAllowedClockSkewInSeconds(30).setRequireSubject().setVerificationKey((Key)this.rsaJsonWebKey.getRsaPublicKey()).build();
        JwtClaims jwtClaims = null;
        SessionManager.Session session = new SessionManager.Session();
        try {
            jwtClaims = jwtConsumer.processToClaims(singedSession);
        }
        catch (InvalidJwtException e) {
            e.printStackTrace();
            return session;
        }
        HashMap<String, String> attr = new HashMap<String, String>();
        for (Map.Entry entry : jwtClaims.flattenClaims().entrySet()) {
            if ("exp".equals(entry.getKey()) || "iat".equals(entry.getKey()) || "jti".equals(entry.getKey()) || "nbf".equals(entry.getKey())) continue;
            if ("sub".equals(entry.getKey())) {
                session.setUserName((String)((List)entry.getValue()).get(0));
                continue;
            }
            if ("level".equals(entry.getKey())) {
                session.setLevel(Integer.parseInt((String)((List)entry.getValue()).get(0)));
                continue;
            }
            if (((String)entry.getKey()).startsWith("map.")) {
                attr.put(((String)entry.getKey()).substring(4), (String)((List)entry.getValue()).get(0));
                continue;
            }
            throw new RuntimeException("not parsed: " + (String)entry.getKey());
        }
        session.setUserAttributes(attr);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String signSession(SessionManager.Session session, Exchange exc) {
        String value = "";
        String userName = session.getUserName();
        if (userName != null) {
            JwtClaims claims = new JwtClaims();
            claims.setExpirationTimeMinutesInTheFuture((float)this.getTimeout() / 60000.0f);
            claims.setIssuedAtToNow();
            claims.setGeneratedJwtId();
            claims.setNotBeforeMinutesInThePast(2.0f);
            claims.setSubject(userName);
            claims.setStringClaim("level", "" + session.getLevel());
            SessionManager.Session session2 = session;
            synchronized (session2) {
                for (Map.Entry<String, String> entry : session.getUserAttributes().entrySet()) {
                    claims.setStringClaim("map." + entry.getKey(), entry.getValue());
                }
            }
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(claims.toJson());
            jws.setKey((Key)this.rsaJsonWebKey.getPrivateKey());
            jws.setKeyIdHeaderValue(this.rsaJsonWebKey.getKeyId());
            jws.setHeader("typ", "JWT");
            jws.setAlgorithmHeaderValue("RS256");
            try {
                value = jws.getCompactSerialization();
            }
            catch (JoseException e) {
                throw new RuntimeException(e);
            }
        }
        return value + "; " + (String)(this.getDomain() != null ? "Domain=" + this.getDomain() + "; " : "") + "Path=/" + (exc.getRule().getSslInboundContext() != null ? "; Secure" : "");
    }

    @Override
    public void postProcess(Exchange exc) {
        SessionManager.Session session = (SessionManager.Session)exc.getProperty("SESSION");
        if (session != null && exc.getResponse() != null) {
            exc.getResponse().getHeader().addCookieSession(this.getCookieName(), this.signSession(session, exc));
        }
    }

    @Override
    public SessionManager.Session getSession(Exchange exc) {
        SessionManager.Session s = (SessionManager.Session)exc.getProperty("SESSION");
        if (s != null) {
            return s;
        }
        String singedSession = exc.getRequest().getHeader().getFirstCookie(this.getCookieName());
        if (singedSession == null) {
            return null;
        }
        SessionManager.Session session = this.validateAndReconstructSession(singedSession);
        exc.setProperty("SESSION", session);
        return session;
    }

    @Override
    public SessionManager.Session createSession(Exchange exc) {
        SessionManager.Session s = new SessionManager.Session();
        exc.setProperty("SESSION", s);
        return s;
    }

    @Override
    public void removeSession(SessionManager.Session s) {
        s.clear();
    }

    @Override
    public void removeSession(Exchange exc) {
        SessionManager.Session s = (SessionManager.Session)exc.getProperty("SESSION");
        if (s == null) {
            return;
        }
        s.clear();
    }

    @Override
    public void cleanup() {
    }
}

