/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.authentication.session;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.authentication.session.AccountBlocker;
import com.predic8.membrane.core.interceptor.authentication.session.CleanupThread;
import com.predic8.membrane.core.interceptor.authentication.session.LoginDialog;
import com.predic8.membrane.core.interceptor.authentication.session.SessionManager;
import com.predic8.membrane.core.interceptor.authentication.session.TokenProvider;
import com.predic8.membrane.core.interceptor.authentication.session.UserDataProvider;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="login")
public class LoginInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)LoginInterceptor.class.getName());
    private String location;
    private String path;
    private String message;
    private boolean exposeUserCredentialsToSession;
    private UserDataProvider userDataProvider;
    private TokenProvider tokenProvider;
    private SessionManager sessionManager;
    private AccountBlocker accountBlocker;
    private LoginDialog loginDialog;

    @Override
    public void init() throws Exception {
        if (this.userDataProvider == null) {
            throw new Exception("No userDataProvider configured. - Cannot work without one.");
        }
        if (this.tokenProvider == null) {
            log.info("No Tokenprovider given, two-factor authentication not enabled");
        }
        if (this.sessionManager == null) {
            this.sessionManager = new SessionManager();
        }
        this.userDataProvider.init(this.router);
        this.loginDialog = new LoginDialog(this.userDataProvider, this.tokenProvider, this.sessionManager, this.accountBlocker, this.location, this.getBasePath(), this.path, this.exposeUserCredentialsToSession, this.message);
    }

    public String getBasePath() {
        Object rule = this.getRule();
        if (rule == null) {
            return "";
        }
        if (rule.getKey().getPath() == null || rule.getKey().isPathRegExp()) {
            return "";
        }
        return rule.getKey().getPath();
    }

    @Override
    public void init(Router router) throws Exception {
        super.init(router);
        if (this.tokenProvider != null) {
            this.tokenProvider.init(router);
        }
        this.loginDialog.init(router);
        this.sessionManager.init(router);
        new CleanupThread(this.sessionManager, this.accountBlocker).start();
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        if (this.loginDialog.isLoginRequest(exc)) {
            this.loginDialog.handleLoginRequest(exc);
            return Outcome.RETURN;
        }
        SessionManager.Session s = this.sessionManager.getSession(exc);
        if (s != null && s.isPreAuthorized()) {
            if (this.tokenProvider == null) {
                s.authorize();
            }
        } else if (s == null || !s.isAuthorized()) {
            return this.loginDialog.redirectToLogin(exc);
        }
        this.applyBackendAuthorization(exc, s);
        return super.handleRequest(exc);
    }

    private void applyBackendAuthorization(Exchange exc, SessionManager.Session s) {
        if (this.getId() != null) {
            exc.setProperty(this.getId() + "-session", s);
        }
        Header h = exc.getRequest().getHeader();
        for (Map.Entry<String, String> e : s.getUserAttributes().entrySet()) {
            if (!e.getKey().startsWith("header")) continue;
            String headerName = e.getKey().substring(6);
            h.removeFields(headerName);
            h.add(headerName, e.getValue());
        }
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        Header header = exc.getResponse().getHeader();
        header.setNoCacheResponseHeaders();
        return super.handleResponse(exc);
    }

    public String getLocation() {
        return this.location;
    }

    @MCAttribute
    @Required
    public void setLocation(String location) {
        this.location = location;
    }

    public String getPath() {
        return this.path;
    }

    @MCAttribute
    @Required
    public void setPath(String path) {
        this.path = path;
    }

    public UserDataProvider getUserDataProvider() {
        return this.userDataProvider;
    }

    @MCChildElement(order=1)
    @Required
    public void setUserDataProvider(UserDataProvider userDataProvider) {
        this.userDataProvider = userDataProvider;
    }

    public TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    @MCChildElement(order=4)
    public void setTokenProvider(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @MCChildElement(order=2)
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public AccountBlocker getAccountBlocker() {
        return this.accountBlocker;
    }

    @MCChildElement(order=3)
    public void setAccountBlocker(AccountBlocker accountBlocker) {
        this.accountBlocker = accountBlocker;
    }

    public boolean isExposeUserCredentialsToSession() {
        return this.exposeUserCredentialsToSession;
    }

    @MCAttribute
    public void setExposeUserCredentialsToSession(boolean exposeUserCredentialsToSession) {
        this.exposeUserCredentialsToSession = exposeUserCredentialsToSession;
    }

    public String getMessage() {
        return this.message;
    }

    @MCAttribute
    public void setMessage(String message) {
        this.message = message;
    }
}

