/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.authentication.session;

import com.google.api.client.util.Base64;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.MCOtherAttributes;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.interceptor.authentication.session.UserDataProvider;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.Crypt;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

@MCElement(name="staticUserDataProvider")
public class StaticUserDataProvider
implements UserDataProvider {
    private List<User> users = new ArrayList<User>();
    private Map<String, User> usersByName = new HashMap<String, User>();
    private BouncyCastleProvider provider = new BouncyCastleProvider();
    private SecureRandom random = new SecureRandom();
    private int saltByteSize = 128;

    @Override
    public Map<String, String> verify(Map<String, String> postData) {
        String pw2;
        String username = postData.get("username");
        if (username == null) {
            throw new NoSuchElementException();
        }
        if (username.equals("error")) {
            throw new RuntimeException();
        }
        User userAttributes = this.getUsersByName().get(username);
        if (userAttributes == null) {
            throw new NoSuchElementException();
        }
        String pw = null;
        String postDataPassword = postData.get("password");
        if (userAttributes.getPassword() != null && this.isHashedPassword(userAttributes.getPassword())) {
            String userHash = userAttributes.getPassword();
            String[] userHashSplit = userHash.split(Pattern.quote("$"));
            String algo = userHashSplit[1];
            String salt = userHashSplit[2];
            try {
                pw = this.createPasswdCompatibleHash(algo, postDataPassword, salt);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e.getMessage());
            }
        } else {
            pw = postDataPassword;
        }
        if ((pw2 = userAttributes.getPassword()) == null || !pw2.equals(pw)) {
            throw new NoSuchElementException();
        }
        return userAttributes.getAttributes();
    }

    private boolean isHashedPassword(String postDataPassword) {
        String[] split = postDataPassword.split(Pattern.quote("$"));
        if (split.length != 4) {
            return false;
        }
        if (!split[0].isEmpty()) {
            return false;
        }
        return split[3].length() >= 20;
    }

    private String createPasswdCompatibleHash(String algo, String password, String salt) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return Crypt.crypt((String)password, (String)("$" + algo + "$" + salt));
    }

    private String createPasswdCompatibleHash(String algo, String password) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        byte[] salt = new byte[this.saltByteSize];
        this.random.nextBytes(salt);
        String saltString = Base64.encodeBase64String((byte[])salt);
        if (saltString.length() > 8) {
            saltString = saltString.substring(0, 8);
        }
        saltString.replaceAll(Pattern.quote("+"), Pattern.quote("."));
        return this.createPasswdCompatibleHash(algo, password, saltString);
    }

    public List<User> getUsers() {
        return this.users;
    }

    @MCChildElement
    public void setUsers(List<User> users) {
        this.getUsersByName().clear();
        for (User user : users) {
            this.getUsersByName().put(user.getUsername(), user);
        }
        this.users = users;
    }

    public Map<String, User> getUsersByName() {
        return this.usersByName;
    }

    public void setUsersByName(Map<String, User> usersByName) {
        this.usersByName = usersByName;
    }

    @Override
    public void init(Router router) {
        for (User user : this.users) {
            this.getUsersByName().put(user.getUsername(), user);
        }
    }

    @MCElement(name="user", topLevel=false, id="staticUserDataProvider-user")
    public static class User {
        Map<String, String> attributes = new HashMap<String, String>();

        public User() {
        }

        public User(String username, String password) {
            this.setUsername(username);
            this.setPassword(password);
        }

        public String getUsername() {
            return this.attributes.get("username");
        }

        @MCAttribute
        public void setUsername(String value) {
            this.attributes.put("username", value);
        }

        public String getPassword() {
            return this.attributes.get("password");
        }

        @MCAttribute
        public void setPassword(String value) {
            this.attributes.put("password", value);
        }

        public String getSms() {
            return this.attributes.get("sms");
        }

        @MCAttribute
        public void setSms(String value) {
            this.attributes.put("sms", value);
        }

        public String getSecret() {
            return this.attributes.get("secret");
        }

        @MCAttribute
        public void setSecret(String value) {
            this.attributes.put("secret", value);
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @MCOtherAttributes
        public void setAttributes(Map<String, String> attributes) {
            for (Map.Entry<String, String> e : attributes.entrySet()) {
                this.attributes.put(e.getKey(), e.getValue());
            }
        }
    }
}

