/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.authentication.session;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.interceptor.authentication.session.SMSTokenProvider;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.util.URLParamUtil;
import com.predic8.membrane.core.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="telekomSMSTokenProvider", topLevel=false)
public class TelekomSMSTokenProvider
extends SMSTokenProvider {
    private static Logger log = LoggerFactory.getLogger((String)TelekomSMSTokenProvider.class.getName());
    private HttpClient hc;
    private String scope;
    private String clientId;
    private String clientSecret;
    private String senderAddress = "0191011";
    private String senderName;
    private EnvironmentType environment = EnvironmentType.BUDGET;
    @GuardedBy(value="this")
    private String token;
    @GuardedBy(value="this")
    private long tokenExpiration;

    @Override
    public void init(Router router) {
        this.hc = router.getHttpClientFactory().createClient(null);
    }

    @Override
    protected String normalizeNumber(String number) {
        return number.replaceAll("\\+", "00").replaceAll("[- ]|\\(.*\\)", "");
    }

    @Override
    protected void sendSMS(String text, String recipientNumber) {
        recipientNumber = recipientNumber.replaceAll("^00", "\\+");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonFactory jsonFactory = new JsonFactory();
            JsonGenerator jg = jsonFactory.createGenerator((OutputStream)baos, JsonEncoding.UTF8);
            jg.writeStartObject();
            jg.writeObjectFieldStart("outboundSMSMessageRequest");
            jg.writeArrayFieldStart("address");
            jg.writeString("tel:" + recipientNumber);
            jg.writeEndArray();
            jg.writeStringField("senderAddress", this.senderAddress);
            jg.writeObjectFieldStart("outboundSMSTextMessage");
            jg.writeStringField("message", text);
            jg.writeEndObject();
            jg.writeStringField("outboundEncoding", "7bitGSM");
            jg.writeStringField("clientCorrelator", "" + (long)(Math.random() * 9.223372036854776E18));
            if (this.senderName != null) {
                jg.writeStringField("senderName", this.senderName);
            }
            jg.writeEndObject();
            jg.writeEndObject();
            jg.close();
            Exchange exc = new Request.Builder().post("https://gateway.developer.telekom.com/plone/sms/rest/" + this.environment.name().toLowerCase() + "/smsmessaging/v1/outbound/" + URLEncoder.encode(this.senderAddress, "UTF-8") + "/requests").header("Host", "gateway.developer.telekom.com").header("Authorization", "OAuth realm=\"developergarden.com\",oauth_token=\"" + this.getAccessToken() + "\"").header("Accept", "application/json").header("Content-Type", "application/json").body(baos.toByteArray()).buildExchange();
            this.hc.call(exc, false, true);
            if (exc.getResponse().getStatusCode() != 201) {
                throw new RuntimeException("Could not send SMS: " + exc.getResponse());
            }
            log.debug("sent SMS to " + recipientNumber);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private synchronized String getAccessToken() throws Exception {
        long now = System.currentTimeMillis();
        if (this.token == null || this.tokenExpiration < now) {
            Exchange exc = new Request.Builder().post("https://global.telekom.com/gcp-web-api/oauth").header("Host", "global.telekom.com").header("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])(this.clientId + ":" + this.clientSecret).getBytes("UTF-8")), "UTF-8")).header("Accept", "application/json").header("User-Agent", "Membrane Service Proxy " + Constants.VERSION).header("Content-Type", "application/x-www-form-urlencoded").body(new URLParamUtil.ParamBuilder().add("grant_type", "client_credentials").add("scope", this.scope).build()).buildExchange();
            this.hc.call(exc, false, true);
            if (exc.getResponse().getStatusCode() != 200) {
                throw new RuntimeException("Telekom Authentication Server returned: " + exc.getResponse());
            }
            HashMap<String, String> values = Util.parseSimpleJSONResponse(exc.getResponse());
            if (!values.containsKey("access_token") || !values.containsKey("expires_in")) {
                throw new Exception("Telekom Authentication: Received 200 and JSON body, but no access_token or no expires_in.");
            }
            this.token = values.get("access_token");
            this.tokenExpiration = Long.parseLong(values.get("expires_in")) + System.currentTimeMillis() - 2000L;
        }
        return this.token;
    }

    public String getScope() {
        return this.scope;
    }

    @MCAttribute
    @Required
    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getClientId() {
        return this.clientId;
    }

    @MCAttribute
    @Required
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    @MCAttribute
    @Required
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getSenderName() {
        return this.senderName;
    }

    @MCAttribute
    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public String getSenderAddress() {
        return this.senderAddress;
    }

    @MCAttribute
    public void setSenderAddress(String senderAddress) {
        this.senderAddress = senderAddress;
    }

    public EnvironmentType getEnvironment() {
        return this.environment;
    }

    @MCAttribute
    public void setEnvironment(EnvironmentType environment) {
        this.environment = environment;
    }

    public static enum EnvironmentType {
        BUDGET,
        PREMIUM,
        MOCK,
        SANDBOX;

    }
}

