/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.authentication.session.totp;

import com.predic8.membrane.core.interceptor.authentication.session.totp.Base32String;
import com.predic8.membrane.core.interceptor.authentication.session.totp.PasscodeGenerator;
import com.predic8.membrane.core.interceptor.authentication.session.totp.TotpCounter;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtpProvider {
    private static Logger log = LoggerFactory.getLogger((String)OtpProvider.class.getName());
    private static final int PIN_LENGTH = 6;
    public static final int DEFAULT_INTERVAL = 30;
    private final TotpCounter mTotpCounter;

    public String getNextCode(String secret, long time) {
        return this.computePin(secret, this.mTotpCounter.getValueAtTime(time / 1000L));
    }

    public OtpProvider() {
        this(30);
    }

    public OtpProvider(int interval) {
        this.mTotpCounter = new TotpCounter(interval);
    }

    private static byte[] decodeKey(String secret) {
        return Base32String.decode(secret);
    }

    static PasscodeGenerator.Signer getSigningOracle(String secret) {
        try {
            byte[] keyBytes = OtpProvider.decodeKey(secret);
            final Mac mac = Mac.getInstance("HMACSHA1");
            mac.init(new SecretKeySpec(keyBytes, ""));
            return new PasscodeGenerator.Signer(){

                @Override
                public byte[] sign(byte[] data) {
                    return mac.doFinal(data);
                }
            };
        }
        catch (NoSuchAlgorithmException error) {
            log.error("", (Throwable)error);
        }
        catch (InvalidKeyException error) {
            log.error("", (Throwable)error);
        }
        return null;
    }

    private String computePin(String secret, long otp_state) {
        if (secret == null || secret.length() == 0) {
            throw new RuntimeException("Null or empty secret");
        }
        try {
            PasscodeGenerator.Signer signer = OtpProvider.getSigningOracle(secret);
            PasscodeGenerator pcg = new PasscodeGenerator(signer, 6);
            return pcg.generateResponseCode(otp_state);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Crypto failure", e);
        }
    }

    public boolean verifyCode(String secret, long time, String code, int window) {
        long t = this.mTotpCounter.getValueAtTime(time / 1000L);
        for (int i = -window; i <= window; ++i) {
            if (!code.equals(this.computePin(secret, t + (long)i))) continue;
            return true;
        }
        return false;
    }
}

