/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.authentication.xen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.security.Blob;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.authentication.session.UserDataProvider;
import com.predic8.membrane.core.interceptor.authentication.xen.XenCredentialAccessor;
import com.predic8.membrane.core.interceptor.authentication.xen.XenSessionIdAccessor;
import java.math.BigInteger;
import java.security.Key;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwk.RsaJwkGenerator;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="xenAuthentication")
public class XenAuthenticationInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(XenAuthenticationInterceptor.class);
    private String user;
    private String password;
    private UserDataProvider userDataProvider;
    private XenSessionManager sessionManager;

    @Override
    public void init(Router router) throws Exception {
        super.init(router);
        this.userDataProvider.init(router);
        this.sessionManager.init(router);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        XenCredentialAccessor.XenLoginData login = new XenCredentialAccessor().getLogin(exc);
        if (login != null) {
            this.userDataProvider.verify((Map<String, String>)ImmutableMap.of((Object)"username", (Object)login.username, (Object)"password", (Object)login.password));
            login.username = this.user;
            login.password = this.password;
            new XenCredentialAccessor().replaceLogin(exc, login);
            return Outcome.CONTINUE;
        }
        String ourSessionId = new XenSessionIdAccessor().getSessionId(exc, Interceptor.Flow.REQUEST);
        String xenSessionId = this.sessionManager.getXenSessionId(ourSessionId);
        if (xenSessionId == null) {
            throw new RuntimeException("Session not found.");
        }
        new XenSessionIdAccessor().replaceSessionId(exc, xenSessionId, Interceptor.Flow.REQUEST);
        return Outcome.CONTINUE;
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        String sessionId = new XenSessionIdAccessor().getSessionId(exc, Interceptor.Flow.RESPONSE);
        if (sessionId == null || sessionId.length() == 0) {
            return Outcome.CONTINUE;
        }
        String newSessionId = this.sessionManager.getExistingSessionId(sessionId);
        if (newSessionId == null) {
            newSessionId = this.sessionManager.createSessionId(sessionId);
        }
        new XenSessionIdAccessor().replaceSessionId(exc, newSessionId, Interceptor.Flow.RESPONSE);
        return Outcome.CONTINUE;
    }

    public String getUser() {
        return this.user;
    }

    @MCAttribute
    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    @MCAttribute
    public void setPassword(String password) {
        this.password = password;
    }

    public UserDataProvider getUserDataProvider() {
        return this.userDataProvider;
    }

    @MCChildElement(order=10)
    public void setUserDataProvider(UserDataProvider userDataProvider) {
        this.userDataProvider = userDataProvider;
    }

    public XenSessionManager getSessionManager() {
        return this.sessionManager;
    }

    @MCChildElement(order=20)
    public void setSessionManager(XenSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public static interface XenSessionManager {
        public void init(Router var1) throws Exception;

        public String getXenSessionId(String var1);

        public String getExistingSessionId(String var1);

        public String createSessionId(String var1);
    }

    @MCElement(name="jwtSessionManager", topLevel=false, id="xenAuthentication-jwtSessionManager")
    public static class JwtSessionManager
    implements XenSessionManager {
        private String audience;
        private Jwk jwk;
        private RsaJsonWebKey rsaJsonWebKey;
        private final SecureRandom random = new SecureRandom();

        @Override
        public void init(Router router) throws Exception {
            String key = this.jwk.get(router.getResolverMap(), router.getBaseLocation());
            this.rsaJsonWebKey = key == null || key.length() == 0 ? this.generateKey() : new RsaJsonWebKey(JsonUtil.parseJson((String)key));
        }

        private RsaJsonWebKey generateKey() throws JoseException {
            RsaJsonWebKey rsaJsonWebKey = RsaJwkGenerator.generateJwk((int)2048);
            rsaJsonWebKey.setKeyId(new BigInteger(130, this.random).toString(32));
            rsaJsonWebKey.setUse("sig");
            rsaJsonWebKey.setAlgorithm("RS256");
            LOG.warn("Using dynamically genererated key, you should write this as <jwtSessionManager ...><jwk>" + rsaJsonWebKey.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE) + "</jwk></jwtSessionManager> .");
            return rsaJsonWebKey;
        }

        @Override
        public String getXenSessionId(String ourSessionId) {
            JwtConsumer consumer = new JwtConsumerBuilder().setExpectedAudience(true, new String[]{this.audience}).setVerificationKeyResolver((VerificationKeyResolver)new JwksVerificationKeyResolver((List)Lists.newArrayList((Object[])new JsonWebKey[]{this.rsaJsonWebKey}))).build();
            try {
                JwtClaims claims = consumer.processToClaims(ourSessionId);
                return claims.getSubject();
            }
            catch (MalformedClaimException | InvalidJwtException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String getExistingSessionId(String xenSessionId) {
            return null;
        }

        @Override
        public String createSessionId(String xenSessionId) {
            JwtClaims jwtClaims = this.createClaims(xenSessionId);
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(jwtClaims.toJson());
            jws.setKey((Key)this.rsaJsonWebKey.getPrivateKey());
            jws.setKeyIdHeaderValue(this.rsaJsonWebKey.getKeyId());
            jws.setAlgorithmHeaderValue("RS256");
            try {
                return jws.getCompactSerialization();
            }
            catch (JoseException e) {
                throw new RuntimeException(e);
            }
        }

        private JwtClaims createClaims(String xenSessionId) {
            JwtClaims jwtClaims = new JwtClaims();
            jwtClaims.setSubject(xenSessionId);
            jwtClaims.setAudience(this.audience);
            jwtClaims.setIssuedAtToNow();
            NumericDate expiration = NumericDate.now();
            expiration.addSeconds(86400L);
            jwtClaims.setExpirationTime(expiration);
            jwtClaims.setNotBeforeMinutesInThePast(2.0f);
            jwtClaims.setClaim("nonce", (Object)this.random.nextLong());
            return jwtClaims;
        }

        public String getAudience() {
            return this.audience;
        }

        @MCAttribute
        public void setAudience(String audience) {
            this.audience = audience;
        }

        public Jwk getJwk() {
            return this.jwk;
        }

        @MCChildElement
        @Required
        public void setJwk(Jwk jwk) {
            this.jwk = jwk;
        }

        @MCElement(name="jwk", mixed=true, topLevel=false, id="xenAuthentication-jwtSessionManager-jwk")
        public static class Jwk
        extends Blob {
        }
    }

    @MCElement(name="inMemorySessionManager", topLevel=false)
    public static class InMemorySessionManager
    implements XenSessionManager {
        private Map<String, String> ourSessionIds = new ConcurrentHashMap<String, String>();
        private Map<String, String> xenSessionIds = new ConcurrentHashMap<String, String>();

        @Override
        public void init(Router router) throws Exception {
        }

        @Override
        public String getXenSessionId(String ourSessionId) {
            return this.ourSessionIds.get(ourSessionId);
        }

        @Override
        public String getExistingSessionId(String xenSessionId) {
            return this.xenSessionIds.get(xenSessionId);
        }

        @Override
        public String createSessionId(String xenSessionId) {
            String newSessionId = UUID.randomUUID().toString();
            this.xenSessionIds.put(xenSessionId, newSessionId);
            this.ourSessionIds.put(newSessionId, xenSessionId);
            return newSessionId;
        }
    }
}

